/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.autocomplete;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.ChoiceModelBehavior;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.renderer.TextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.form.autocomplete.AutoCompleteBehavior;
import com.googlecode.wicket.kendo.ui.form.autocomplete.IAutoCompleteListener;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public abstract class AbstractAutoCompleteTextField<T, C>
extends TextField<T>
implements IJQueryWidget,
IAutoCompleteListener {
    private static final long serialVersionUID = 1L;
    private List<C> choices = null;
    private ChoiceModelBehavior<C> choiceModelBehavior;
    final ITextRenderer<? super C> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    private int width = 0;

    public AbstractAutoCompleteTextField(String id) {
        this(id, (ITextRenderer<C>)new TextRenderer(), null);
    }

    public AbstractAutoCompleteTextField(String id, ITextRenderer<? super C> renderer) {
        this(id, renderer, null);
    }

    public AbstractAutoCompleteTextField(String id, Class<T> type) {
        this(id, (ITextRenderer<C>)new TextRenderer(), type);
    }

    public AbstractAutoCompleteTextField(String id, ITextRenderer<? super C> renderer, Class<T> type) {
        super(id, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public AbstractAutoCompleteTextField(String id, IModel<T> model) {
        this(id, model, (ITextRenderer<C>)new TextRenderer(), null);
    }

    public AbstractAutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super C> renderer) {
        this(id, model, renderer, null);
    }

    public AbstractAutoCompleteTextField(String id, IModel<T> model, Class<T> type) {
        this(id, model, (ITextRenderer<C>)new TextRenderer(), type);
    }

    public AbstractAutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super C> renderer, Class<T> type) {
        super(id, model, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    protected CharSequence getCallbackUrl() {
        return this.choiceModelBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    public int getListWidth() {
        return this.width;
    }

    public AbstractAutoCompleteTextField<T, C> setListWidth(int width) {
        this.width = width;
        return this;
    }

    public ITextRenderer<? super C> getRenderer() {
        return this.renderer;
    }

    private List<C> internalGetChoices(String input) {
        this.choices = this.getChoices(input);
        return this.choices;
    }

    public List<C> getChoices() {
        if (this.choices != null) {
            return this.choices;
        }
        return Collections.emptyList();
    }

    protected abstract List<C> getChoices(String var1);

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("autocomplete", (CharSequence)"off");
    }

    @Override
    public final void onSelect(AjaxRequestTarget target, int index) {
        if (-1 < index && index < this.choices.size()) {
            this.onSelected(target, this.choices.get(index));
        }
    }

    protected void onSelected(AjaxRequestTarget target, C choice) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AutoCompleteBehavior(selector, (IAutoCompleteListener)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return AbstractAutoCompleteTextField.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource dataSource) {
                AbstractAutoCompleteTextField.this.onConfigure(dataSource);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected ChoiceModelBehavior<C> newChoiceModelBehavior() {
        return new ChoiceModelBehavior<C>(this.renderer, this.template){
            private static final long serialVersionUID = 1L;
            private static final String TERM = "filter[filters][0][value]";

            public List<C> getChoices() {
                String input = RequestCycleUtils.getQueryParameterValue((String)TERM).toString();
                return AbstractAutoCompleteTextField.this.internalGetChoices(input);
            }
        };
    }
}

