/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.dataviz;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.ChartDataSource;
import com.googlecode.wicket.kendo.ui.dataviz.IChartListener;
import com.googlecode.wicket.kendo.ui.dataviz.series.Series;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public abstract class ChartBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoChart";
    private final IChartListener listener;
    private KendoDataSource dataSource;
    private JQueryAjaxBehavior onSeriesClickAjaxBehavior = null;
    private final List<Series> series;

    public ChartBehavior(String selector, List<Series> series, IChartListener listener) {
        this(selector, new Options(), series, listener);
    }

    public ChartBehavior(String selector, Options options, List<Series> series, IChartListener listener) {
        super(selector, METHOD, options);
        this.series = series;
        this.listener = (IChartListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new ChartDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isSeriesClickEventEnabled()) {
            this.onSeriesClickAjaxBehavior = this.newOnSeriesClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onSeriesClickAjaxBehavior});
        }
    }

    protected abstract CharSequence getProviderUrl();

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.onSeriesClickAjaxBehavior != null) {
            this.setOption("seriesClick", this.onSeriesClickAjaxBehavior.getCallbackFunction());
        }
        this.setOption("series", new JSONArray(this.series).toString());
        this.onConfigure(this.dataSource);
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.setTransportReadUrl(this.getProviderUrl());
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SeriesClickEvent) {
            SeriesClickEvent e = (SeriesClickEvent)event;
            this.listener.onSeriesClick(target, e.getSeriesField(), e.getSeriesName(), e.getCategory(), e.getValue());
        }
    }

    protected JQueryAjaxBehavior newOnSeriesClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSeriesClickAjaxBehavior(source);
    }

    protected static class SeriesClickEvent
    extends JQueryEvent {
        private final long value = RequestCycleUtils.getQueryParameterValue((String)"value").toOptionalLong();
        private final String category = RequestCycleUtils.getQueryParameterValue((String)"category").toString();
        private final String seriesName;
        private final String seriesField = RequestCycleUtils.getQueryParameterValue((String)"seriesField").toString();

        public SeriesClickEvent() {
            this.seriesName = RequestCycleUtils.getQueryParameterValue((String)"seriesName").toString();
        }

        public long getValue() {
            return this.value;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public String getSeriesField() {
            return this.seriesField;
        }
    }

    protected static class OnSeriesClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSeriesClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"value", (String)"e.value"), CallbackParameter.resolved((String)"seriesName", (String)"e.series.name"), CallbackParameter.resolved((String)"seriesField", (String)"e.series.field"), CallbackParameter.resolved((String)"category", (String)"e.category")};
        }

        protected JQueryEvent newEvent() {
            return new SeriesClickEvent();
        }
    }
}

