/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.column;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.resource.JavaScriptPackageHeaderItem;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.datatable.DataTable;
import com.googlecode.wicket.kendo.ui.datatable.column.PropertyColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.ComponentRenderer;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.util.lang.Generics;

public abstract class AjaxPropertyColumn
extends PropertyColumn {
    private static final long serialVersionUID = 1L;

    public AjaxPropertyColumn(String title, DataTable<?> datatable) {
        super(title);
        this.bind((Component)datatable);
    }

    public AjaxPropertyColumn(String title, String property, DataTable<?> datatable) {
        super(title, property);
        this.bind((Component)datatable);
    }

    public AjaxPropertyColumn(String title, int width, DataTable<?> datatable) {
        super(title, width);
        this.bind((Component)datatable);
    }

    public AjaxPropertyColumn(String title, String property, int width, DataTable<?> datatable) {
        super(title, property, width);
        this.bind((Component)datatable);
    }

    public AjaxPropertyColumn(IModel<String> title, String property, DataTable<?> datatable) {
        super(title, property);
        this.bind((Component)datatable);
    }

    public AjaxPropertyColumn(IModel<String> title, String property, int width, DataTable<?> datatable) {
        super(title, property, width);
        this.bind((Component)datatable);
    }

    private final void bind(Component component) {
        component.add(new Behavior[]{new AjaxTemplateBehavior()});
    }

    @Override
    public final Boolean isEditable() {
        return false;
    }

    @Override
    public final String getTemplate() {
        return "#= loadAjaxPropertyColumn(data) #";
    }

    protected abstract Component newLazyComponent(String var1, String var2);

    protected class AjaxTemplateBehavior
    extends AjaxCallbackBehavior {
        private static final long serialVersionUID = 1L;

        public AjaxTemplateBehavior() {
            super("text/html");
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            HashMap variables = Generics.newHashMap();
            variables.put("field", AjaxPropertyColumn.this.getField());
            variables.put("imageUrl", RequestCycle.get().urlFor((IRequestHandler)new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR)));
            variables.put("callbackUrl", this.getCallbackUrl());
            response.render((HeaderItem)new JavaScriptPackageHeaderItem(AjaxPropertyColumn.class, (Map)variables));
        }

        protected String getResponse(IRequestParameters parameters) {
            String value = RequestCycleUtils.getQueryParameterValue((String)"id").toString();
            Component component = AjaxPropertyColumn.this.newLazyComponent(this.newMarkupId(), value);
            CharSequence response = ComponentRenderer.renderComponent((Component)component);
            return response != null ? response.toString() : "";
        }

        private String newMarkupId() {
            return "col-" + UUID.randomUUID();
        }
    }
}

