/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.datatable.button.ToolbarButton;
import java.util.List;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;

public class ToolbarAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final ToolbarButton button;

    public ToolbarAjaxBehavior(IJQueryAjaxAware source) {
        this(source, null);
    }

    public ToolbarAjaxBehavior(IJQueryAjaxAware source, ToolbarButton button) {
        super(source);
        this.button = (ToolbarButton)Args.notNull((Object)button, (String)"button");
    }

    public String getButtonName() {
        return this.button.getName();
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"values", (String)ToolbarAjaxBehavior.getValuesFunction("jQuery(e.target).closest('.k-grid').data('kendoGrid')", this.button.getProperty()))};
    }

    public static String getValuesFunction(String grid, String property) {
        if (property != null) {
            return String.format("function() { var values = []; var $grid = %s; $grid.select().each(  function(index, row) {     values.push($grid.dataItem(row)['%s']);   } ); return values; }()", grid, property);
        }
        return "[]";
    }

    protected JQueryEvent newEvent() {
        return new ToolbarClickEvent(this.button);
    }

    public static class ToolbarClickEvent
    extends JQueryEvent {
        private final ToolbarButton button;
        private final List<String> values;

        public ToolbarClickEvent(ToolbarButton button) {
            this.button = button;
            this.values = Generics.newArrayList();
            String values = RequestCycleUtils.getQueryParameterValue((String)"values").toString("");
            if (!Strings.isEmpty((CharSequence)values)) {
                for (String value : values.split(",")) {
                    this.values.add(value);
                }
            }
        }

        public ToolbarButton getButton() {
            return this.button;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

