/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataSourceAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataSourceEvent;
import com.googlecode.wicket.kendo.ui.datatable.IDataTableListener;
import com.googlecode.wicket.kendo.ui.datatable.button.CommandAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.button.CommandButton;
import com.googlecode.wicket.kendo.ui.datatable.button.ToolbarAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.button.ToolbarButton;
import com.googlecode.wicket.kendo.ui.datatable.column.CommandColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.IdPropertyColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public abstract class DataTableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoGrid";
    private final IDataTableListener listener;
    private final IModel<List<IColumn>> columns;
    private KendoDataSource dataSource;
    private JQueryAjaxBehavior onCancelAjaxBehavior;
    private JQueryAjaxBehavior onCreateAjaxBehavior;
    private JQueryAjaxBehavior onUpdateAjaxBehavior;
    private JQueryAjaxBehavior onDeleteAjaxBehavior;

    public DataTableBehavior(String selector, IModel<List<IColumn>> columns, IDataTableListener listener) {
        this(selector, new Options(), columns, listener);
    }

    public DataTableBehavior(String selector, Options options, IModel<List<IColumn>> columns, IDataTableListener listener) {
        super(selector, METHOD, options);
        this.columns = columns;
        this.listener = (IDataTableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.add(this.dataSource);
        this.onCancelAjaxBehavior = this.newOnCancelAjaxBehavior(this);
        component.add(new Behavior[]{this.onCancelAjaxBehavior});
        this.onCreateAjaxBehavior = this.newOnCreateAjaxBehavior(this);
        component.add(new Behavior[]{this.onCreateAjaxBehavior});
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        this.onDeleteAjaxBehavior = this.newOnDeleteAjaxBehavior(this);
        component.add(new Behavior[]{this.onDeleteAjaxBehavior});
        for (ToolbarButton toolbarButton : this.getToolbarButtons()) {
            if (toolbarButton.isBuiltIn()) continue;
            component.add(new Behavior[]{this.newToolbarAjaxBehavior(this, toolbarButton)});
        }
        for (CommandButton commandButton : this.getCommandButtons()) {
            if (commandButton.isBuiltIn()) continue;
            component.add(new Behavior[]{this.newCommandAjaxBehavior(this, commandButton)});
        }
    }

    protected abstract long getRowCount();

    protected abstract CharSequence getProviderUrl();

    protected boolean useCache() {
        return false;
    }

    protected List<ToolbarButton> getToolbarButtons() {
        return Collections.emptyList();
    }

    private boolean hasVisibleToolbarButtons() {
        return !this.getToolbarButtons().isEmpty();
    }

    protected List<ToolbarButton> getVisibleToolbarButtons() {
        ArrayList buttons = Generics.newArrayList();
        for (ToolbarButton button : this.getToolbarButtons()) {
            if (!button.isVisible()) continue;
            buttons.add(button);
        }
        return buttons;
    }

    private List<CommandButton> getCommandButtons() {
        for (IColumn column : (List)this.columns.getObject()) {
            if (!(column instanceof CommandColumn)) continue;
            return ((CommandColumn)column).getButtons();
        }
        return Collections.emptyList();
    }

    private List<String> getCommandButtonsAsString(CommandColumn column, List<CommandAjaxBehavior> behaviors) {
        ArrayList list = Generics.newArrayList();
        for (CommandButton button : column.getButtons()) {
            if (!button.isVisible()) continue;
            JQueryAjaxBehavior behavior = this.getCommandAjaxBehavior(button, behaviors);
            list.add(button.toString(behavior));
        }
        return list;
    }

    private JQueryAjaxBehavior getCommandAjaxBehavior(CommandButton button, List<CommandAjaxBehavior> behaviors) {
        for (CommandAjaxBehavior behavior : behaviors) {
            if (!button.equals(behavior.getButton())) continue;
            return behavior;
        }
        return null;
    }

    private String getColumnsAsString(List<IColumn> columns, List<CommandAjaxBehavior> behaviors) {
        StringBuilder builder = new StringBuilder("[ ");
        for (int i = 0; i < columns.size(); ++i) {
            IColumn column = columns.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("{ ");
            builder.append(column.toString());
            if (column instanceof CommandColumn) {
                builder.append(", ");
                builder.append("\"").append("command").append("\"").append(": ");
                builder.append(this.getCommandButtonsAsString((CommandColumn)column, behaviors));
            }
            builder.append(" }");
        }
        return builder.append(" ]").toString();
    }

    private String getReadCallbackFunction() {
        return KendoDataSource.getReadCallbackFunction(this.getProviderUrl(), this.useCache());
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        List columns = (List)this.columns.getObject();
        this.setOption("cancel", this.onCancelAjaxBehavior.getCallbackFunction());
        if (this.hasVisibleToolbarButtons()) {
            this.setOption("toolbar", this.getVisibleToolbarButtons());
        }
        this.setOption("columns", this.getColumnsAsString(columns, component.getBehaviors(CommandAjaxBehavior.class)));
        Options schema = new Options();
        schema.set("data", (Object)Options.asString((String)"results"));
        schema.set("total", (Object)Options.asString((String)"__count"));
        schema.set("model", (Object)this.newSchemaModelOptions(columns));
        this.onConfigure(this.dataSource);
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.set("schema", schema);
        this.dataSource.set("pageSize", this.getRowCount());
        this.dataSource.set("serverPaging", true);
        this.dataSource.set("serverSorting", true);
        this.dataSource.set("serverFiltering", true);
        this.dataSource.setTransportRead(this.getReadCallbackFunction());
        this.dataSource.setTransportCreate(this.onCreateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportUpdate(this.onUpdateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportDelete(this.onDeleteAjaxBehavior.getCallbackFunction());
        for (ToolbarAjaxBehavior behavior : component.getBehaviors(ToolbarAjaxBehavior.class)) {
            String selector = String.format("%s .k-grid-toolbar .k-grid-%s", this.getSelector(), behavior.getButtonName());
            this.off(selector, "click");
            this.on(selector, "click", behavior.getCallbackFunction());
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        JQueryEvent e;
        if (event instanceof CommandAjaxBehavior.ClickEvent) {
            e = (CommandAjaxBehavior.ClickEvent)event;
            e.getButton().onClick(target, e.getValue());
            this.listener.onClick(target, e.getButton(), e.getValue());
        }
        if (event instanceof ToolbarAjaxBehavior.ToolbarClickEvent) {
            e = (ToolbarAjaxBehavior.ToolbarClickEvent)event;
            this.listener.onClick(target, e.getButton(), e.getValues());
        }
        if (event instanceof CancelEvent) {
            this.listener.onCancel(target);
        }
        if (event instanceof DataSourceEvent.CreateEvent) {
            this.listener.onCreate(target, ((DataSourceEvent.CreateEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.UpdateEvent) {
            this.listener.onUpdate(target, ((DataSourceEvent.UpdateEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.DeleteEvent) {
            this.listener.onDelete(target, ((DataSourceEvent.DeleteEvent)event).getObject());
        }
    }

    protected Options newSchemaModelOptions(List<IColumn> columns) {
        Options model = new Options();
        Options fields = new Options();
        for (IColumn column : columns) {
            if (column.getField() == null) continue;
            Options field = new Options();
            if (column instanceof IdPropertyColumn) {
                model.set("id", (Object)Options.asString((String)column.getField()));
            }
            if (column.isEditable() != null) {
                field.set("editable", (Object)column.isEditable());
            }
            if (column.isNullable() != null) {
                field.set("nullable", (Object)column.isNullable());
            }
            if (column.getType() != null) {
                field.set("type", (Object)Options.asString((String)column.getType()));
            }
            fields.set(column.getField(), (Object)field);
        }
        model.set("fields", (Object)fields);
        return model;
    }

    protected JQueryAjaxBehavior newOnCancelAjaxBehavior(IJQueryAjaxAware source) {
        return new JQueryAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e")};
            }

            protected JQueryEvent newEvent() {
                return new CancelEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnCreateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.CreateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.UpdateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnDeleteAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.DeleteEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newToolbarAjaxBehavior(DataTableBehavior source, ToolbarButton button) {
        return new ToolbarAjaxBehavior(source, button);
    }

    protected abstract JQueryAjaxBehavior newCommandAjaxBehavior(IJQueryAjaxAware var1, CommandButton var2);

    protected static class CancelEvent
    extends JQueryEvent {
        protected CancelEvent() {
        }
    }
}

