/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;

public final class KendoBehaviorFactory {
    public static void show(IPartialPageRequestHandler handler, Component component) {
        KendoBehaviorFactory.show(handler, IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public static void show(IPartialPageRequestHandler handler, String selector) {
        handler.appendJavaScript((CharSequence)KendoBehaviorFactory.getShowStatement(selector));
    }

    public static void hide(IPartialPageRequestHandler handler, Component component) {
        KendoBehaviorFactory.hide(handler, IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public static void hide(IPartialPageRequestHandler handler, String selector) {
        handler.appendJavaScript((CharSequence)KendoBehaviorFactory.getHideStatement(selector));
    }

    public static JQueryBehavior newShowBehavior(Component component) {
        return KendoBehaviorFactory.newShowBehavior(IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public static JQueryBehavior newShowBehavior(String selector) {
        return new JQueryBehavior(selector){
            private static final long serialVersionUID = 1L;

            protected String $() {
                return KendoBehaviorFactory.getShowStatement(this.selector);
            }
        };
    }

    public static JQueryBehavior newHideBehavior(Component component) {
        return KendoBehaviorFactory.newHideBehavior(IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public static JQueryBehavior newHideBehavior(String selector) {
        return new JQueryBehavior(selector){
            private static final long serialVersionUID = 1L;

            protected String $() {
                return KendoBehaviorFactory.getHideStatement(this.selector);
            }
        };
    }

    public static String getShowStatement(String selector) {
        return String.format("jQuery('%s').closest('.k-widget').show();", selector);
    }

    public static String getHideStatement(String selector) {
        return String.format("jQuery('%s').closest('.k-widget').hide();", selector);
    }

    private KendoBehaviorFactory() {
    }
}

