/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.resource.JavaScriptPackageHeaderItem;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerListener;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerDataSource;
import com.googlecode.wicket.kendo.ui.scheduler.views.SchedulerViewType;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.lang.Args;

public abstract class SchedulerBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoScheduler";
    private final ISchedulerListener listener;
    private SchedulerDataSource dataSource;
    private JQueryAjaxBehavior onEditAjaxBehavior = null;
    private JQueryAjaxBehavior onNavigateAjaxBehavior;
    private JQueryAjaxBehavior onCreateAjaxBehavior;
    private JQueryAjaxBehavior onUpdateAjaxBehavior;
    private JQueryAjaxBehavior onDeleteAjaxBehavior;

    public SchedulerBehavior(String selector, ISchedulerListener listener) {
        this(selector, new Options(), listener);
    }

    public SchedulerBehavior(String selector, Options options, ISchedulerListener listener) {
        super(selector, METHOD, options);
        this.listener = (ISchedulerListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new SchedulerDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isEditEnabled()) {
            this.onEditAjaxBehavior = this.newOnEditAjaxBehavior(this);
            component.add(new Behavior[]{this.onEditAjaxBehavior});
        }
        this.onNavigateAjaxBehavior = this.newOnNavigateAjaxBehavior(this);
        component.add(new Behavior[]{this.onNavigateAjaxBehavior});
        this.onCreateAjaxBehavior = this.newOnCreateAjaxBehavior(this);
        component.add(new Behavior[]{this.onCreateAjaxBehavior});
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        this.onDeleteAjaxBehavior = this.newOnDeleteAjaxBehavior(this);
        component.add(new Behavior[]{this.onDeleteAjaxBehavior});
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)new JavaScriptPackageHeaderItem(SchedulerBehavior.class));
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("autoBind", true);
        this.setOption("navigate", this.onNavigateAjaxBehavior.getCallbackFunction());
        if (this.onEditAjaxBehavior != null) {
            this.setOption("edit", this.onEditAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.set("serverFiltering", true);
        this.dataSource.setTransportRead(this.getReadCallbackFunction());
        this.dataSource.setTransportCreate(this.onCreateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportUpdate(this.onUpdateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportDelete(this.onDeleteAjaxBehavior.getCallbackFunction());
        this.onConfigure(this.dataSource);
        super.onConfigure(component);
    }

    protected void onConfigure(SchedulerDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof NavigateEvent) {
            NavigateEvent navigateEvent = (NavigateEvent)event;
            this.listener.onNavigate(target, navigateEvent.oldView, navigateEvent.newView);
        }
        if (event instanceof SchedulerPayload) {
            SchedulerPayload payload = (SchedulerPayload)event;
            JSONObject object = payload.getObject();
            if (event instanceof EditEvent) {
                this.listener.onEdit(target, object, payload.getView());
            }
            if (event instanceof CreateEvent) {
                this.listener.onCreate(target, object);
            }
            if (event instanceof UpdateEvent) {
                this.listener.onUpdate(target, object);
            }
            if (event instanceof DeleteEvent) {
                this.listener.onDelete(target, object);
            }
        }
    }

    protected abstract CharSequence getDataSourceUrl();

    private String getReadCallbackFunction() {
        String widget = this.widget();
        String start = widget + ".view().startDate().getTime()";
        String end = String.format("calculateKendoSchedulerViewEndPeriod(%s.view().endDate()).getTime()", widget);
        return "function(options) { jQuery.ajax({\t\turl: '" + this.getDataSourceUrl() + "',\t\tdata: { start: " + start + ", end: " + end + " },\t\tcache: false,\t\tdataType: 'json',\t\tsuccess: function(result) { \t\t\toptions.success(result);\t\t},\t\terror: function(result) {\t\t\toptions.error(result);\t\t}\t});}";
    }

    protected JQueryAjaxBehavior newOnNavigateAjaxBehavior(IJQueryAjaxAware source) {
        return new OnNavigateAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEditAjaxBehavior(IJQueryAjaxAware source) {
        return new OnEditAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new EditEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnCreateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new CreateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new UpdateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnDeleteAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DeleteEvent();
            }
        };
    }

    protected static class DeleteEvent
    extends SchedulerPayload {
        protected DeleteEvent() {
        }
    }

    protected static class UpdateEvent
    extends SchedulerPayload {
        protected UpdateEvent() {
        }
    }

    protected static class CreateEvent
    extends SchedulerPayload {
        protected CreateEvent() {
        }
    }

    protected static class EditEvent
    extends SchedulerPayload {
        protected EditEvent() {
        }
    }

    protected static class SchedulerPayload
    extends JQueryEvent {
        private SchedulerViewType view = null;
        private JSONObject object;

        public SchedulerPayload() {
            String view;
            String data = RequestCycleUtils.getRequestParameterValue((String)"data").toString();
            if (data != null) {
                this.object = new JSONObject(data);
            }
            if ((view = RequestCycleUtils.getRequestParameterValue((String)"view").toString()) != null) {
                this.view = SchedulerViewType.get(view);
            }
        }

        public JSONObject getObject() {
            return this.object;
        }

        public SchedulerViewType getView() {
            return this.view;
        }
    }

    protected static class NavigateEvent
    extends JQueryEvent {
        private SchedulerViewType oldView = null;
        private SchedulerViewType newView = null;

        public NavigateEvent() {
            String oldView = RequestCycleUtils.getQueryParameterValue((String)"oldview").toString();
            String newView = RequestCycleUtils.getQueryParameterValue((String)"newview").toString();
            if (oldView != null) {
                this.oldView = SchedulerViewType.get(oldView);
            }
            if (newView != null) {
                this.newView = SchedulerViewType.get(newView);
            }
        }

        public SchedulerViewType getOldView() {
            return this.oldView;
        }

        public SchedulerViewType getNewView() {
            return this.newView;
        }
    }

    protected static abstract class DataSourceAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public DataSourceAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"data", (String)"kendo.stringify(e.data)")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String statement = "";
            statement = statement + "e.data.start = e.data.start.getTime();\n";
            statement = statement + "e.data.end = e.data.end.getTime();\n";
            statement = statement + super.getCallbackFunctionBody(parameters);
            statement = statement + "e.success();";
            return statement;
        }
    }

    protected static abstract class OnEditAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnEditAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"data", (String)"kendo.stringify(e.event)"), CallbackParameter.resolved((String)"view", (String)"e.sender.view().name")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String statement = "";
            statement = statement + "e.event.start = e.event.start.getTime();\n";
            statement = statement + "e.event.end = e.event.end.getTime();\n";
            statement = statement + super.getCallbackFunctionBody(parameters);
            statement = statement + "e.preventDefault();";
            return statement;
        }
    }

    protected static class OnNavigateAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnNavigateAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"oldview", (String)"e.sender.view().name"), CallbackParameter.resolved((String)"newview", (String)"e.view")};
        }

        protected JQueryEvent newEvent() {
            return new NavigateEvent();
        }
    }
}

