/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.repeater;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.BuilderUtils;
import com.googlecode.wicket.jquery.core.utils.ListUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.IRequestParameters;

public class DataProviderBehavior<T>
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final IDataProvider<T> provider;
    private final ITextRenderer<? super T> renderer;
    private final IJQueryTemplate template;

    public DataProviderBehavior(IDataProvider<T> provider, ITextRenderer<? super T> renderer) {
        this(provider, renderer, null);
    }

    public DataProviderBehavior(IDataProvider<T> provider, ITextRenderer<? super T> renderer, IJQueryTemplate template) {
        this.provider = provider;
        this.renderer = renderer;
        this.template = template;
    }

    protected List<String> getProperties() {
        if (this.template != null) {
            return ListUtils.exclude((List)this.template.getTextProperties(), (List)this.renderer.getFields());
        }
        return Collections.emptyList();
    }

    protected String getResponse(IRequestParameters parameters) {
        int first = parameters.getParameterValue("skip").toInt(0);
        int count = parameters.getParameterValue("take").toInt(Short.MAX_VALUE);
        long size = this.provider.size();
        Iterator iterator = this.provider.iterator((long)first, (long)count);
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        BuilderUtils.append((StringBuilder)builder, (String)"__count", (Object)size);
        builder.append(", ");
        builder.append("\"").append("results").append("\"").append(": ");
        builder.append("[ ");
        if (iterator != null) {
            int index = 0;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (index > 0) {
                    builder.append(", ");
                }
                builder.append("{ ");
                builder.append(this.renderer.render(object));
                for (String property : this.getProperties()) {
                    builder.append(", ");
                    BuilderUtils.append((StringBuilder)builder, (String)property, (String)this.renderer.getText(object, property));
                }
                builder.append(" }");
                ++index;
            }
        }
        builder.append(" ] }");
        return builder.toString();
    }

    public void detach(Component component) {
        super.detach(component);
        this.provider.detach();
    }
}

