/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.resource.JavaScriptPackageHeaderItem;
import com.googlecode.wicket.kendo.ui.KendoBehaviorFactory;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataProviderBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataTableBehavior;
import com.googlecode.wicket.kendo.ui.datatable.IDataTableListener;
import com.googlecode.wicket.kendo.ui.datatable.behavior.DataBoundBehavior;
import com.googlecode.wicket.kendo.ui.datatable.button.CommandAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.button.CommandButton;
import com.googlecode.wicket.kendo.ui.datatable.button.ToolbarButton;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DataTable<T>
extends WebComponent
implements IGenericComponent<List<IColumn>>,
IJQueryWidget,
IDataTableListener {
    private static final long serialVersionUID = 1L;
    private final long rows;
    private final IDataProvider<T> provider;
    private AbstractAjaxBehavior providerBehavior;
    protected final Options options;

    public DataTable(String id, IDataProvider<T> provider, long rows) {
        this(id, provider, rows, new Options());
    }

    public DataTable(String id, IDataProvider<T> provider, long rows, Options options) {
        super(id);
        this.provider = provider;
        this.options = options;
        this.rows = rows;
    }

    public DataTable(String id, List<IColumn> columns, IDataProvider<T> provider, long rows) {
        this(id, (IModel<List<IColumn>>)Model.ofList(columns), provider, rows, new Options());
    }

    public DataTable(String id, List<IColumn> columns, IDataProvider<T> provider, long rows, Options options) {
        this(id, (IModel<List<IColumn>>)Model.ofList(columns), provider, rows, options);
    }

    public DataTable(String id, IModel<List<IColumn>> columns, IDataProvider<T> provider, long rows) {
        this(id, columns, provider, rows, new Options());
    }

    public DataTable(String id, IModel<List<IColumn>> columns, IDataProvider<T> provider, long rows, Options options) {
        super(id, columns);
        this.provider = provider;
        this.options = options;
        this.rows = rows;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new JavaScriptPackageHeaderItem(DataTable.class));
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoGrid");
    }

    public final void show(IPartialPageRequestHandler handler) {
        this.onShow(handler);
        KendoBehaviorFactory.show(handler, (Component)this);
    }

    public final void hide(IPartialPageRequestHandler handler) {
        KendoBehaviorFactory.hide(handler, (Component)this);
        this.onHide(handler);
    }

    public void reset(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.page(1); }", this.widget()));
    }

    public void reload(IPartialPageRequestHandler handler) {
        this.reload(handler, false);
    }

    public void reload(IPartialPageRequestHandler handler, boolean reset) {
        if (reset) {
            this.reset(handler);
        }
        handler.add(new Component[]{this});
    }

    public void refresh(IPartialPageRequestHandler handler) {
        this.refresh(handler, false);
    }

    public void refresh(IPartialPageRequestHandler handler, boolean reset) {
        if (reset) {
            this.reset(handler);
        }
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
    }

    public IModel<List<IColumn>> getModel() {
        return this.getDefaultModel();
    }

    public void setModel(IModel<List<IColumn>> model) {
        this.setDefaultModel(model);
    }

    public List<IColumn> getModelObject() {
        return (List)this.getDefaultModelObject();
    }

    public void setModelObject(List<IColumn> object) {
        this.setDefaultModelObject(object);
    }

    public IDataProvider<T> getDataProvider() {
        return this.provider;
    }

    protected final long getRowCount() {
        return this.rows;
    }

    public final List<IColumn> getColumns() {
        if (this.getModelObject() != null) {
            return Collections.unmodifiableList(this.getModelObject());
        }
        return Collections.emptyList();
    }

    protected final CharSequence getCallbackUrl() {
        return this.providerBehavior.getCallbackUrl();
    }

    protected List<ToolbarButton> getToolbarButtons() {
        return Collections.emptyList();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.providerBehavior = this.newDataProviderBehavior(this.getModel(), this.getDataProvider());
        this.add(new Behavior[]{this.providerBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("sortable", (Object)(this.getDataProvider() instanceof ISortStateLocator));
        behavior.setOption("autoBind", (Object)this.getBehaviors(DataBoundBehavior.class).isEmpty());
        behavior.setOption("dataBound", (Object)"datatable_dataBound");
        behavior.setOption("edit", (Object)"datatable_edit");
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, "");
    }

    public void onShow(IPartialPageRequestHandler handler) {
    }

    public void onHide(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, ToolbarButton button, List<String> values) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, CommandButton button, String value) {
    }

    @Override
    public void onCancel(AjaxRequestTarget target) {
    }

    @Override
    public void onColumnReorder(AjaxRequestTarget target, int oldIndex, int newIndex, JSONObject column) {
    }

    @Override
    public void onCreate(AjaxRequestTarget target, JSONObject object) {
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, JSONObject object) {
    }

    @Override
    public void onDelete(AjaxRequestTarget target, JSONObject object) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DataTableBehavior(selector, this.options, this.getModel(), this){
            private static final long serialVersionUID = 1L;

            @Override
            protected long getRowCount() {
                return DataTable.this.getRowCount();
            }

            @Override
            protected CharSequence getProviderUrl() {
                return DataTable.this.getCallbackUrl();
            }

            @Override
            protected List<ToolbarButton> getToolbarButtons() {
                return DataTable.this.getToolbarButtons();
            }

            @Override
            protected void onConfigure(KendoDataSource dataSource) {
                DataTable.this.onConfigure(dataSource);
            }

            @Override
            protected JQueryAjaxBehavior newCommandAjaxBehavior(IJQueryAjaxAware source, CommandButton button) {
                return DataTable.this.newCommandAjaxBehavior(source, button);
            }
        };
    }

    protected AbstractAjaxBehavior newDataProviderBehavior(IModel<List<IColumn>> columns, IDataProvider<T> provider) {
        return new DataProviderBehavior<T>(columns, provider);
    }

    protected JQueryAjaxBehavior newCommandAjaxBehavior(IJQueryAjaxAware source, CommandButton button) {
        return new CommandAjaxBehavior(source, button);
    }
}

