/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.PropertyColumn;
import com.googlecode.wicket.kendo.ui.utils.PropertyUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SingleSortState;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.convert.ConversionException;

public class DataProviderBehavior<T>
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private static final String ASC = "asc";
    private static final int COLS = 20;
    private final IDataProvider<T> provider;
    private final IModel<List<IColumn>> columns;

    public DataProviderBehavior(IModel<List<IColumn>> columns, IDataProvider<T> provider) {
        this.columns = columns;
        this.provider = provider;
    }

    protected void setSort(String property, SortOrder order) {
        ISortStateLocator locator = (ISortStateLocator)this.provider;
        ISortState sortState = locator.getSortState();
        if (property != null) {
            sortState.setPropertySortOrder((Object)property, order);
        } else if (sortState instanceof SingleSortState) {
            ((SingleSortState)sortState).setSort(null);
        }
    }

    protected String getResponse(IRequestParameters parameters) {
        int first = parameters.getParameterValue("skip").toInt(0);
        int count = parameters.getParameterValue("take").toInt(Short.MAX_VALUE);
        if (this.provider instanceof ISortStateLocator) {
            String property = parameters.getParameterValue("sort[0][field]").toOptionalString();
            String direction = parameters.getParameterValue("sort[0][dir]").toOptionalString();
            this.setSort(PropertyUtils.unescape(property), direction == null ? SortOrder.NONE : (ASC.equals(direction) ? SortOrder.ASCENDING : SortOrder.DESCENDING));
        }
        if (this.provider instanceof IFilterStateLocator) {
            String logicPattern = "filter[logic]";
            String fieldPattern = "filter[filters][%d][field]";
            String valuePattern = "filter[filters][%d][value]";
            String operatorPattern = "filter[filters][%d][operator]";
            Object object = ((IFilterStateLocator)this.provider).getFilterState();
            PropertyResolverConverter converter = this.newPropertyResolverConverter();
            for (int i = 0; i < 20; ++i) {
                String field = parameters.getParameterValue(String.format(fieldPattern, i)).toOptionalString();
                String value = parameters.getParameterValue(String.format(valuePattern, i)).toOptionalString();
                if (field == null) break;
                PropertyResolver.setValue((String)PropertyUtils.unescape(field), (Object)object, (Object)value, (PropertyResolverConverter)converter);
            }
        }
        JSONArray results = new JSONArray();
        Iterator iterator = this.provider.iterator((long)first, (long)count);
        if (iterator != null) {
            while (iterator.hasNext()) {
                results.put((Object)this.newJsonRow(iterator.next()));
            }
        }
        JSONObject object = new JSONObject();
        object.put("results", (Object)results);
        object.put("__count", this.provider.size());
        return object.toString();
    }

    public void detach(Component component) {
        super.detach(component);
        this.provider.detach();
    }

    protected PropertyResolverConverter newPropertyResolverConverter() {
        return new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
    }

    protected JSONObject newJsonRow(T bean) {
        JSONObject object = new JSONObject();
        try {
            for (IColumn column : (List)this.columns.getObject()) {
                if (!(column instanceof PropertyColumn)) continue;
                PropertyColumn pc = (PropertyColumn)column;
                object.put(pc.getField(), pc.getValue(bean));
            }
        }
        catch (JSONException e) {
            throw new ConversionException((Throwable)e);
        }
        return object;
    }
}

