/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.kendo.ui.form.button.AjaxButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;

public abstract class WindowButtonPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public WindowButtonPanel(String id, List<WindowButton> buttons) {
        super(id);
        RepeatingView view = new RepeatingView("buttons");
        this.add(new Component[]{view});
        for (WindowButton button : buttons) {
            view.add(new Component[]{this.newAjaxButton(view.newChildId(), button)});
        }
    }

    protected abstract Form<?> getForm();

    protected abstract void onError(AjaxRequestTarget var1, WindowButton var2);

    protected abstract void onSubmit(AjaxRequestTarget var1, WindowButton var2);

    protected abstract void onAfterSubmit(AjaxRequestTarget var1, WindowButton var2);

    protected AjaxButton newAjaxButton(String id, final WindowButton button) {
        return new AjaxButton(id, this.getForm()){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getIcon() {
                return button.getIcon();
            }

            public boolean isEnabled() {
                return button.isEnabled();
            }

            public boolean isVisible() {
                return button.isVisible();
            }

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.add(new Component[]{new Label("text", button.getTextModel()).setRenderBodyOnly(true)});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setDefaultFormProcessing(button.getDefaultFormProcessing());
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                WindowButtonPanel.this.onSubmit(target, button);
            }

            @Override
            protected void onError(AjaxRequestTarget target, Form<?> form) {
                WindowButtonPanel.this.onError(target, button);
            }

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                WindowButtonPanel.this.onAfterSubmit(target, button);
            }
        };
    }
}

