/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.kendo.ui.KendoIcon;
import com.googlecode.wicket.kendo.ui.widget.window.Window;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class MessageWindow
extends Window<String> {
    private static final long serialVersionUID = 1L;
    private Component label;
    private final Form<?> form;

    public MessageWindow(String id, String title, String message, WindowButtons buttons) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons.toList(), "");
    }

    public MessageWindow(String id, String title, String message, List<WindowButton> buttons) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons, "");
    }

    public MessageWindow(String id, String title, String message, WindowButtons buttons, String icon) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons.toList(), icon);
    }

    public MessageWindow(String id, String title, String message, List<WindowButton> buttons, String icon) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)), buttons, icon);
    }

    public MessageWindow(String id, IModel<String> title, IModel<String> message, WindowButtons buttons) {
        this(id, title, message, buttons.toList(), "");
    }

    public MessageWindow(String id, IModel<String> title, IModel<String> message, List<WindowButton> buttons) {
        this(id, title, message, buttons, "");
    }

    public MessageWindow(String id, IModel<String> title, IModel<String> message, WindowButtons buttons, String icon) {
        this(id, title, message, buttons.toList(), icon);
    }

    public MessageWindow(String id, IModel<String> title, IModel<String> message, List<WindowButton> buttons, String icon) {
        super(id, title, message, buttons);
        this.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)KendoIcon.getCssClass(icon)))})});
        this.form = MessageWindow.newForm("form");
        this.add(new Component[]{this.form});
    }

    @Override
    protected Form<?> getForm() {
        return this.form;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.label = this.newLabel("text", (IModel<String>)this.getModel());
        this.add(new Component[]{this.label});
        this.form.add(new Component[]{this.newButtonPanel("buttons", this.getButtons())});
    }

    @Override
    protected void onOpen(AjaxRequestTarget target) {
        target.add(new Component[]{this.label});
    }

    private static Form<Void> newForm(String id) {
        return new Form<Void>(id){
            private static final long serialVersionUID = 1L;

            public boolean wantSubmitOnParentFormSubmit() {
                return false;
            }
        };
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model).setOutputMarkupId(true);
    }
}

