/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.kendo.ui.form.TextField;
import com.googlecode.wicket.kendo.ui.panel.KendoFeedbackPanel;
import com.googlecode.wicket.kendo.ui.widget.window.Window;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class InputWindow<T>
extends Window<T> {
    private static final long serialVersionUID = 1L;
    private final KendoFeedbackPanel feedback;
    private final Form<?> form;
    private IModel<String> labelModel;

    public InputWindow(String id, String title, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), null, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<String> label) {
        this(id, title, null, label);
    }

    public InputWindow(String id, String title, IModel<T> model, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<T> model, IModel<String> label) {
        super(id, title, model, WindowButtons.OK_CANCEL);
        this.labelModel = label;
        this.form = InputWindow.newForm("form");
        this.add(new Component[]{this.form});
        this.feedback = this.newFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.form.add(new Component[]{this.newLabel("label", this.labelModel)});
        this.form.add(new Component[]{this.newTextField("input", this.getModel()).setRequired(this.isRequired())});
        this.form.add(new Component[]{this.newButtonPanel("buttons", this.getButtons())});
    }

    @Override
    protected void onOpen(AjaxRequestTarget target) {
        super.onOpen(target);
        target.add(new Component[]{this.form});
    }

    @Override
    protected void onError(AjaxRequestTarget target, WindowButton button) {
        target.add(new Component[]{this.feedback});
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target, WindowButton button) {
        if (button != null) {
            if (button.match("OK")) {
                this.onSubmit(target);
            } else if (button.match("CANCEL")) {
                this.onCancel(target);
            }
        }
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected void onCancel(AjaxRequestTarget target) {
    }

    protected void onDetach() {
        super.onDetach();
        this.labelModel.detach();
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    protected boolean isRequired() {
        return true;
    }

    private static Form<Void> newForm(String id) {
        return new Form<Void>(id){
            private static final long serialVersionUID = 1L;

            public boolean wantSubmitOnParentFormSubmit() {
                return false;
            }
        };
    }

    protected KendoFeedbackPanel newFeedbackPanel(String id) {
        return new KendoFeedbackPanel(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected FeedbackMessagesModel newFeedbackMessagesModel() {
                FeedbackMessagesModel model = new FeedbackMessagesModel((Component)this);
                model.setFilter((IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)InputWindow.this));
                return model;
            }
        };
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected FormComponent<T> newTextField(String id, IModel<T> model) {
        return new TextField<T>(id, model);
    }
}

