/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.window.IWindowListener;
import com.googlecode.wicket.kendo.ui.widget.window.WindowBehavior;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractWindow<T>
extends GenericPanel<T>
implements IJQueryWidget,
IWindowListener {
    private static final long serialVersionUID = 1L;
    protected static final String ACTION_PIN = "pin";
    protected static final String ACTION_CLOSE = "close";
    protected static final String ACTION_REFRESH = "refresh";
    protected static final String ACTION_CUSTOM = "custom";
    protected static final String ACTION_MINIMIZE = "minimize";
    protected static final String ACTION_MAXIMIZE = "maximize";
    private static final int WIDTH = 450;
    private IModel<String> title;
    private boolean modal;
    private WindowBehavior widgetBehavior;

    public AbstractWindow(String id, String title) {
        this(id, title, null, true);
    }

    public AbstractWindow(String id, IModel<String> title) {
        this(id, title, null, true);
    }

    public AbstractWindow(String id, String title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractWindow(String id, IModel<String> title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractWindow(String id, String title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractWindow(String id, IModel<String> title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractWindow(String id, String title, IModel<T> model, boolean modal) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, modal);
    }

    public AbstractWindow(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, model);
        this.title = title;
        this.modal = modal;
    }

    public final void open(AjaxRequestTarget target) {
        this.onOpen(target);
        if (this.widgetBehavior != null) {
            this.widgetBehavior.open(target);
        }
    }

    public final void close(AjaxRequestTarget target) {
        if (this.widgetBehavior != null) {
            this.widgetBehavior.close(target);
        }
        this.onClose(target);
    }

    public int getWidth() {
        return 450;
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public void setTitle(IModel<String> title) {
        Args.notNull(title, (String)"title");
        this.title = title;
    }

    public void setTitle(AjaxRequestTarget target, String title) {
        this.setTitle(target, (IModel<String>)Model.of((Serializable)((Object)title)));
    }

    public void setTitle(AjaxRequestTarget target, IModel<String> title) {
        this.setTitle(title);
        target.appendJavaScript((CharSequence)String.format("%s.title(%s);", this.widgetBehavior.widget(), Options.asString((String)((String)title.getObject()))));
    }

    public final boolean isModal() {
        return this.modal;
    }

    public boolean isCentered() {
        return false;
    }

    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isActionEventEnabled() {
        return false;
    }

    @Override
    public boolean isCloseEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.widgetBehavior = (WindowBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("title", (Object)Options.asString((String)((String)this.getTitle().getObject())));
        behavior.setOption("modal", (Object)this.isModal());
        behavior.setOption("resizable", (Object)this.isResizable());
        behavior.setOption("width", (Object)this.getWidth());
        behavior.setOption("visible", (Object)false);
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    protected void onOpen(AjaxRequestTarget target) {
    }

    @Override
    public void onAction(AjaxRequestTarget target, String action) {
    }

    @Override
    public void onClose(AjaxRequestTarget target) {
    }

    public WindowBehavior newWidgetBehavior(String selector) {
        return new WindowBehavior(selector){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isCentered() {
                return AbstractWindow.this.isCentered();
            }

            @Override
            public boolean isActionEventEnabled() {
                return AbstractWindow.this.isActionEventEnabled();
            }

            @Override
            public boolean isCloseEventEnabled() {
                return AbstractWindow.this.isCloseEventEnabled();
            }

            @Override
            public void onAction(AjaxRequestTarget target, String action) {
                AbstractWindow.this.onAction(target, action);
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                AbstractWindow.this.onClose(target);
            }
        };
    }
}

