/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.splitter;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.splitter.ISplitterListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;

public class SplitterBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
ISplitterListener {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoSplitter";
    private JQueryAjaxBehavior onExpandAjaxBehavior;
    private JQueryAjaxBehavior onCollapseAjaxBehavior;

    public SplitterBehavior(String selector) {
        this(selector, new Options());
    }

    public SplitterBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    public void bind(Component component) {
        super.bind(component);
        this.onExpandAjaxBehavior = this.newOnExpandAjaxBehavior(this);
        component.add(new Behavior[]{this.onExpandAjaxBehavior});
        this.onCollapseAjaxBehavior = this.newOnCollapseAjaxBehavior(this);
        component.add(new Behavior[]{this.onCollapseAjaxBehavior});
    }

    public void expand(AjaxRequestTarget target, String pane) {
        target.appendJavaScript((CharSequence)String.format("$('%s').data('%s').expand('%s');", this.selector, METHOD, pane));
    }

    public void collapse(AjaxRequestTarget target, String pane) {
        target.appendJavaScript((CharSequence)String.format("$('%s').data('%s').collapse('%s');", this.selector, METHOD, pane));
    }

    @Override
    public boolean isExpandEventEnabled() {
        return false;
    }

    @Override
    public boolean isCollapseEventEnabled() {
        return false;
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("expand", this.onExpandAjaxBehavior.getCallbackFunction());
        this.setOption("collapse", this.onCollapseAjaxBehavior.getCallbackFunction());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ExpandEvent) {
            this.onExpand(target, ((ExpandEvent)event).getPaneId());
        }
        if (event instanceof CollapseEvent) {
            this.onCollapse(target, ((CollapseEvent)event).getPaneId());
        }
    }

    @Override
    public void onExpand(AjaxRequestTarget target, String paneId) {
    }

    @Override
    public void onCollapse(AjaxRequestTarget target, String paneId) {
    }

    protected JQueryAjaxBehavior newOnExpandAjaxBehavior(IJQueryAjaxAware source) {
        return new OnExpandAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnCollapseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnCollapseAjaxBehavior(source);
    }

    protected static class CollapseEvent
    extends JQueryEvent {
        private final String paneId = RequestCycleUtils.getQueryParameterValue((String)"id").toString("");

        public String getPaneId() {
            return this.paneId;
        }
    }

    protected static class ExpandEvent
    extends JQueryEvent {
        private final String paneId = RequestCycleUtils.getQueryParameterValue((String)"id").toString("");

        public String getPaneId() {
            return this.paneId;
        }
    }

    protected static class OnCollapseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnCollapseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"id", (String)"e.pane.id")};
        }

        protected JQueryEvent newEvent() {
            return new CollapseEvent();
        }
    }

    protected static class OnExpandAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnExpandAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"id", (String)"e.pane.id")};
        }

        protected JQueryEvent newEvent() {
            return new ExpandEvent();
        }
    }
}

