/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.progressbar;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.progressbar.IProgressBarListener;
import com.googlecode.wicket.kendo.ui.widget.progressbar.ProgressBarBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ProgressBar
extends JQueryGenericContainer<Integer>
implements IProgressBarListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN = 0;
    private static final int MAX = 100;
    private final Options options;
    private boolean valueChanged = false;

    public ProgressBar(String id) {
        this(id, new Options());
    }

    public ProgressBar(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public ProgressBar(String id, IModel<Integer> model) {
        this(id, model, new Options());
    }

    public ProgressBar(String id, IModel<Integer> model, Options options) {
        super(id, model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public int getMin() {
        Integer min = (Integer)this.options.get("min");
        return min != null ? min : 0;
    }

    public int getMax() {
        Integer max = (Integer)this.options.get("max");
        return max != null ? max : 100;
    }

    public void setModelObject(Integer value) {
        Integer v = (Integer)Args.notNull((Object)value, (String)"value");
        if (v < this.getMin()) {
            v = this.getMin();
        } else if (v > this.getMax()) {
            v = this.getMax();
        }
        this.setDefaultModelObject(v);
    }

    protected String widget() {
        return String.format("jQuery('%s').data('%s')", IJQueryWidget.JQueryWidget.getSelector((Component)this), "kendoProgressBar");
    }

    public void forward(AjaxRequestTarget target) {
        this.forward(target, 1);
    }

    public final void forward(AjaxRequestTarget target, int step) {
        this.setModelObject((Integer)this.getModelObject() + step);
        this.refresh(target);
    }

    public final void backward(AjaxRequestTarget target) {
        this.backward(target, 1);
    }

    public final void backward(AjaxRequestTarget target, int step) {
        this.setModelObject((Integer)this.getModelObject() - step);
        this.refresh(target);
    }

    public final void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("%s.value(%d);", this.widget(), this.getModelObject()));
        if (this.valueChanged) {
            this.valueChanged = false;
            this.onValueChanged(target);
            if ((Integer)this.getModelObject() >= this.getMax()) {
                this.onComplete(target);
            }
        }
    }

    protected void onModelChanged() {
        this.valueChanged = true;
    }

    public void onValueChanged(AjaxRequestTarget target) {
    }

    @Override
    public void onComplete(AjaxRequestTarget target) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ProgressBarBehavior(selector, this.options);
    }
}

