/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.menu;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.menu.IMenuListener;
import com.googlecode.wicket.kendo.ui.widget.menu.item.IMenuItem;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;

public abstract class MenuBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
IMenuListener {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoMenu";
    private JQueryAjaxBehavior onSelectAjaxBehavior;

    public MenuBehavior(String selector) {
        super(selector, METHOD);
    }

    MenuBehavior(String selector, String method) {
        super(selector, method);
    }

    public MenuBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    MenuBehavior(String selector, String method, Options options) {
        super(selector, method, options);
    }

    protected abstract Map<String, IMenuItem> getMenuItemMap();

    public void bind(Component component) {
        super.bind(component);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        IMenuItem item;
        if (event instanceof SelectEvent && (item = this.getMenuItemMap().get(((SelectEvent)event).getHash())) != null) {
            item.onClick(target);
            this.onClick(target, item);
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final String hash = RequestCycleUtils.getQueryParameterValue((String)"hash").toString();

        public String getHash() {
            return this.hash;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"hash", (String)"e.item.id")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

