/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.menu;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.widget.menu.IContextMenuListener;
import com.googlecode.wicket.kendo.ui.widget.menu.MenuBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;

public abstract class ContextMenuBehavior
extends MenuBehavior
implements IContextMenuListener {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoContextMenu";
    private JQueryAjaxBehavior onOpenAjaxBehavior = null;

    public ContextMenuBehavior(String selector) {
        super(selector, METHOD);
    }

    public ContextMenuBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    @Override
    public void bind(Component component) {
        super.bind(component);
        if (this.isOpenEventEnabled()) {
            this.onOpenAjaxBehavior = this.newOnOpenAjaxBehavior(this);
            component.add(new Behavior[]{this.onOpenAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.onOpenAjaxBehavior != null) {
            this.setOption("open", this.onOpenAjaxBehavior.getCallbackFunction());
        }
    }

    @Override
    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        super.onAjax(target, event);
        if (event instanceof OpenEvent) {
            this.onOpen(target);
        }
    }

    protected JQueryAjaxBehavior newOnOpenAjaxBehavior(IJQueryAjaxAware source) {
        return new OnOpenAjaxBehavior(source);
    }

    protected static class OpenEvent
    extends JQueryEvent {
        protected OpenEvent() {
        }
    }

    public static class OnOpenAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnOpenAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected JQueryEvent newEvent() {
            return new OpenEvent();
        }
    }
}

