/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerVisitor;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModel;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public class SchedulerModelBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final SchedulerModel model;

    public SchedulerModelBehavior(SchedulerModel model) {
        this.model = model;
    }

    public void onRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        long start = parameters.getParameterValue("start").toLong(0L);
        long end = parameters.getParameterValue("end").toLong(0L);
        if (this.model != null) {
            this.setStartDate(this.model, start);
            this.setEndDate(this.model, end);
        }
        requestCycle.scheduleRequestHandlerAfterCurrent(this.newRequestHandler());
    }

    protected void setStartDate(SchedulerModel model, long date) {
        model.setStart(date);
    }

    protected void setEndDate(SchedulerModel model, long date) {
        model.setEnd(date);
    }

    protected IRequestHandler newRequestHandler() {
        return new SchedulerModelRequestHandler();
    }

    protected class SchedulerModelRequestHandler
    implements IRequestHandler {
        protected SchedulerModelRequestHandler() {
        }

        public void respond(IRequestCycle requestCycle) {
            List list;
            WebResponse response = (WebResponse)requestCycle.getResponse();
            String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
            response.setContentType("text/json; charset=" + encoding);
            response.disableCaching();
            if (SchedulerModelBehavior.this.model != null && (list = (List)SchedulerModelBehavior.this.model.getObject()) != null) {
                StringBuilder builder = new StringBuilder("[ ");
                int count = 0;
                for (SchedulerEvent event : list) {
                    if (SchedulerModelBehavior.this.model instanceof ISchedulerVisitor) {
                        event.accept((ISchedulerVisitor)((Object)SchedulerModelBehavior.this.model));
                    }
                    if (!event.isVisible()) continue;
                    if (count++ > 0) {
                        builder.append(", ");
                    }
                    builder.append(event.toJson());
                }
                response.write((CharSequence)builder.append(" ]"));
            }
        }

        public void detach(IRequestCycle requestCycle) {
            SchedulerModelBehavior.this.model.detach();
        }
    }
}

