/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerListener;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerDataSource;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceList;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceListModel;
import com.googlecode.wicket.kendo.ui.scheduler.views.SchedulerViewType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

public abstract class SchedulerBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
ISchedulerListener {
    private static final long serialVersionUID = 1L;
    private static final JavaScriptResourceReference JS = new JavaScriptResourceReference(SchedulerBehavior.class, "SchedulerBehavior.js");
    static final String METHOD = "kendoScheduler";
    private final SchedulerDataSource dataSource = new SchedulerDataSource("schedulerDataSource");
    private JQueryAjaxBehavior onEditAjaxBehavior = null;
    private JQueryAjaxBehavior onNavigateAjaxBehavior;
    private JQueryAjaxBehavior onCreateAjaxBehavior;
    private JQueryAjaxBehavior onUpdateAjaxBehavior;
    private JQueryAjaxBehavior onDeleteAjaxBehavior;

    public SchedulerBehavior(String selector) {
        this(selector, new Options());
    }

    public SchedulerBehavior(String selector, Options options) {
        super(selector, METHOD, options);
        this.add(this.dataSource);
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.isEditEnabled()) {
            this.onEditAjaxBehavior = this.newOnEditAjaxBehavior(this);
            component.add(new Behavior[]{this.onEditAjaxBehavior});
        }
        this.onNavigateAjaxBehavior = this.newOnNavigateAjaxBehavior(this);
        component.add(new Behavior[]{this.onNavigateAjaxBehavior});
        this.onCreateAjaxBehavior = this.newOnCreateAjaxBehavior(this);
        component.add(new Behavior[]{this.onCreateAjaxBehavior});
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        this.onDeleteAjaxBehavior = this.newOnDeleteAjaxBehavior(this);
        component.add(new Behavior[]{this.onDeleteAjaxBehavior});
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
    }

    protected abstract CharSequence getDataSourceUrl();

    protected abstract ResourceListModel getResourceListModel();

    private String getReadCallbackFunction() {
        String widget = this.widget();
        String start = widget + ".view().startDate().getTime()";
        String end = String.format("calculateKendoSchedulerViewEndPeriod(%s.view().endDate()).getTime()", widget);
        return "function(options) { jQuery.ajax({\t\turl: '" + this.getDataSourceUrl() + "'," + "\t\tdata: { start: " + start + ",  end: " + end + "}," + "\t\tcache: false," + "\t\tdataType: 'json'," + "\t\tsuccess: function(result) {" + "\t\t\toptions.success(result);" + "\t\t}," + "\t\terror: function(result) {" + "\t\t\toptions.error(result);" + "\t\t}" + "\t});" + "}";
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("autoBind", true);
        this.setOption("navigate", this.onNavigateAjaxBehavior.getCallbackFunction());
        if (this.onEditAjaxBehavior != null) {
            this.setOption("edit", this.onEditAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.setTransportRead(this.getReadCallbackFunction());
        this.dataSource.setTransportCreate(this.onCreateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportUpdate(this.onUpdateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportDelete(this.onDeleteAjaxBehavior.getCallbackFunction());
        this.setOption("resources", (Object)this.getResourceListModel());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof NavigateEvent) {
            this.onNavigate(target, ((NavigateEvent)event).getView());
        }
        if (event instanceof SchedulerPayload) {
            SchedulerPayload payload = (SchedulerPayload)event;
            if (event instanceof EditEvent) {
                this.onEdit(target, payload.getEvent(), payload.getView());
            }
            if (event instanceof CreateEvent) {
                this.onCreate(target, payload.getEvent());
            }
            if (event instanceof UpdateEvent) {
                this.onUpdate(target, payload.getEvent());
            }
            if (event instanceof DeleteEvent) {
                this.onDelete(target, payload.getEvent());
            }
        }
    }

    protected JQueryAjaxBehavior newOnNavigateAjaxBehavior(IJQueryAjaxAware source) {
        return new OnNavigateAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEditAjaxBehavior(IJQueryAjaxAware source) {
        return new OnEditAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new EditEvent(SchedulerBehavior.this.getResourceListModel());
            }
        };
    }

    protected JQueryAjaxBehavior newOnCreateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new CreateEvent(SchedulerBehavior.this.getResourceListModel());
            }
        };
    }

    protected JQueryAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new UpdateEvent(SchedulerBehavior.this.getResourceListModel());
            }
        };
    }

    protected JQueryAjaxBehavior newOnDeleteAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DeleteEvent(SchedulerBehavior.this.getResourceListModel());
            }
        };
    }

    protected static class DeleteEvent
    extends SchedulerPayload {
        public DeleteEvent(ResourceListModel listModel) {
            super(listModel);
        }
    }

    protected static class UpdateEvent
    extends SchedulerPayload {
        public UpdateEvent(ResourceListModel listModel) {
            super(listModel);
        }
    }

    protected static class CreateEvent
    extends SchedulerPayload {
        public CreateEvent(ResourceListModel listModel) {
            super(listModel);
        }
    }

    protected static class EditEvent
    extends SchedulerPayload {
        public EditEvent(ResourceListModel listModel) {
            super(listModel);
        }
    }

    protected static class SchedulerPayload
    extends JQueryEvent {
        private final SchedulerEvent event;
        private SchedulerViewType view = null;

        public SchedulerPayload(ResourceListModel listModel) {
            int id = RequestCycleUtils.getQueryParameterValue((String)"id").toInt();
            String title = RequestCycleUtils.getQueryParameterValue((String)"title").toString();
            String description = RequestCycleUtils.getQueryParameterValue((String)"description").toString();
            long start = RequestCycleUtils.getQueryParameterValue((String)"start").toLong();
            long end = RequestCycleUtils.getQueryParameterValue((String)"end").toLong();
            boolean allDay = RequestCycleUtils.getQueryParameterValue((String)"isAllDay").toBoolean();
            String recurrenceId = RequestCycleUtils.getQueryParameterValue((String)"recurrenceId").toString();
            String recurrenceRule = RequestCycleUtils.getQueryParameterValue((String)"recurrenceRule").toString();
            String recurrenceException = RequestCycleUtils.getQueryParameterValue((String)"recurrenceException").toString();
            this.event = new SchedulerEvent(id, title, start, end);
            this.event.setAllDay(allDay);
            this.event.setDescription(description);
            this.event.setRecurrenceId(recurrenceId);
            this.event.setRecurrenceRule(recurrenceRule);
            this.event.setRecurrenceException(recurrenceException);
            Pattern pattern = Pattern.compile("([\\w-]+)");
            for (ResourceList list : (List)listModel.getObject()) {
                String field = list.getField();
                StringValue value = RequestCycleUtils.getQueryParameterValue((String)field);
                ArrayList<String> values = new ArrayList<String>();
                if (value != null) {
                    Matcher matcher = pattern.matcher(value.toString());
                    while (matcher.find()) {
                        values.add(matcher.group());
                    }
                }
                if (list.isMultiple()) {
                    this.event.setResource(field, values);
                    continue;
                }
                if (values.isEmpty()) continue;
                this.event.setResource(field, (String)values.get(0));
            }
            String view = RequestCycleUtils.getQueryParameterValue((String)"view").toString();
            if (view != null) {
                this.view = SchedulerViewType.get(view);
            }
        }

        public SchedulerEvent getEvent() {
            return this.event;
        }

        public SchedulerViewType getView() {
            return this.view;
        }
    }

    protected static class NavigateEvent
    extends JQueryEvent {
        private SchedulerViewType view = null;

        public NavigateEvent() {
            String view = RequestCycleUtils.getQueryParameterValue((String)"view").toString();
            if (view != null) {
                this.view = SchedulerViewType.get(view);
            }
        }

        public SchedulerViewType getView() {
            return this.view;
        }
    }

    protected abstract class DataSourceAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public DataSourceAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            ArrayList<CallbackParameter> parameters = new ArrayList<CallbackParameter>();
            parameters.add(CallbackParameter.context((String)"e"));
            parameters.add(CallbackParameter.resolved((String)"id", (String)"e.data.id"));
            parameters.add(CallbackParameter.resolved((String)"title", (String)"e.data.title"));
            parameters.add(CallbackParameter.resolved((String)"description", (String)"e.data.description"));
            parameters.add(CallbackParameter.resolved((String)"start", (String)"e.data.start.getTime()"));
            parameters.add(CallbackParameter.resolved((String)"end", (String)"e.data.end.getTime()"));
            parameters.add(CallbackParameter.resolved((String)"isAllDay", (String)"e.data.isAllDay"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceId", (String)"e.data.recurrenceId"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceRule", (String)"e.data.recurrenceRule"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceException", (String)"e.data.recurrenceException"));
            for (String field : SchedulerBehavior.this.getResourceListModel().getFields()) {
                parameters.add(CallbackParameter.resolved((String)field, (String)("e.data." + field)));
            }
            return parameters.toArray(new CallbackParameter[0]);
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return super.getCallbackFunctionBody(parameters) + " e.success();";
        }
    }

    protected abstract class OnEditAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnEditAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            ArrayList<CallbackParameter> parameters = new ArrayList<CallbackParameter>();
            parameters.add(CallbackParameter.context((String)"e"));
            parameters.add(CallbackParameter.resolved((String)"id", (String)"e.event.id"));
            parameters.add(CallbackParameter.resolved((String)"title", (String)"e.event.title"));
            parameters.add(CallbackParameter.resolved((String)"description", (String)"e.event.description"));
            parameters.add(CallbackParameter.resolved((String)"start", (String)"e.event.start.getTime()"));
            parameters.add(CallbackParameter.resolved((String)"end", (String)"e.event.end.getTime()"));
            parameters.add(CallbackParameter.resolved((String)"isAllDay", (String)"e.event.isAllDay"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceId", (String)"e.event.recurrenceId"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceRule", (String)"e.event.recurrenceRule"));
            parameters.add(CallbackParameter.resolved((String)"recurrenceException", (String)"e.event.recurrenceException"));
            for (String field : SchedulerBehavior.this.getResourceListModel().getFields()) {
                parameters.add(CallbackParameter.resolved((String)field, (String)String.format("jQuery.makeArray(e.event.%s)", field)));
            }
            parameters.add(CallbackParameter.resolved((String)"view", (String)"e.sender.view().name"));
            return parameters.toArray(new CallbackParameter[0]);
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return super.getCallbackFunctionBody(parameters) + " e.preventDefault();";
        }
    }

    protected static class OnNavigateAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnNavigateAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"view", (String)"e.sender.view().name")};
        }

        protected JQueryEvent newEvent() {
            return new NavigateEvent();
        }
    }
}

