/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.kendo.ui.KendoTemplateBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerListener;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModel;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModelBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceList;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceListModel;
import com.googlecode.wicket.kendo.ui.scheduler.views.SchedulerViewType;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class Scheduler
extends JQueryContainer
implements ISchedulerListener {
    private static final long serialVersionUID = 1L;
    private final Options options;
    private SchedulerModelBehavior modelBehavior;
    private final ResourceListModel resourceListModel = new ResourceListModel();
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;

    public Scheduler(String id) {
        this(id, null, new Options());
    }

    public Scheduler(String id, Options options) {
        this(id, null, options);
    }

    public Scheduler(String id, SchedulerModel model) {
        this(id, model, new Options());
    }

    public Scheduler(String id, SchedulerModel model, Options options) {
        super(id, (IModel)model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
        this.template = this.newTemplate();
    }

    public Scheduler(String id, SchedulerModel model, ResourceList resourceList) {
        this(id, model, resourceList, new Options());
    }

    public Scheduler(String id, SchedulerModel model, ResourceList resourceList, Options options) {
        this(id, model, options);
        this.resourceListModel.add(resourceList);
    }

    public void add(ResourceList resourceList) {
        this.resourceListModel.add(resourceList);
    }

    protected String widget() {
        return String.format("jQuery('%s').data('%s')", IJQueryWidget.JQueryWidget.getSelector((Component)this), "kendoScheduler");
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("var widget = %s; widget.dataSource.read(); widget.refresh();", this.widget()));
    }

    @Override
    public boolean isEditEnabled() {
        return false;
    }

    public SchedulerModel getModel() {
        return (SchedulerModel)this.getDefaultModel();
    }

    protected GroupOrientation getGroupOrientation() {
        return GroupOrientation.horizontal;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newSchedulerModelBehavior(this.getModel());
        this.add(new Behavior[]{this.modelBehavior});
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        behavior.setOption("timezone", (Object)Options.asString((String)"Etc/UTC"));
        List<String> groups = this.resourceListModel.getGroups();
        if (!groups.isEmpty()) {
            Options options = new Options();
            options.set("resources", (Object)Options.asString(groups));
            options.set("orientation", (Object)Options.asString((Object)((Object)this.getGroupOrientation())));
            behavior.setOption("group", (Object)options);
        }
        if (this.templateBehavior != null) {
            behavior.setOption("eventTemplate", (Object)String.format("jQuery('#%s').html()", this.templateBehavior.getToken()));
        }
    }

    @Override
    public void onEdit(AjaxRequestTarget target, SchedulerEvent event, SchedulerViewType view) {
    }

    @Override
    public void onNavigate(AjaxRequestTarget target, SchedulerViewType view) {
        this.refresh(target);
    }

    @Override
    public void onCreate(AjaxRequestTarget target, SchedulerEvent event) {
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, SchedulerEvent event) {
    }

    @Override
    public void onDelete(AjaxRequestTarget target, SchedulerEvent event) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SchedulerBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEditEnabled() {
                return Scheduler.this.isEditEnabled();
            }

            @Override
            protected CharSequence getDataSourceUrl() {
                return Scheduler.this.modelBehavior.getCallbackUrl();
            }

            @Override
            protected ResourceListModel getResourceListModel() {
                return Scheduler.this.resourceListModel;
            }

            @Override
            public void onEdit(AjaxRequestTarget target, SchedulerEvent event, SchedulerViewType view) {
                Scheduler.this.onEdit(target, event, view);
            }

            @Override
            public void onNavigate(AjaxRequestTarget target, SchedulerViewType view) {
                Scheduler.this.onNavigate(target, view);
            }

            @Override
            public void onCreate(AjaxRequestTarget target, SchedulerEvent event) {
                Scheduler.this.onCreate(target, event);
            }

            @Override
            public void onUpdate(AjaxRequestTarget target, SchedulerEvent event) {
                Scheduler.this.onUpdate(target, event);
            }

            @Override
            public void onDelete(AjaxRequestTarget target, SchedulerEvent event) {
                Scheduler.this.onDelete(target, event);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected SchedulerModelBehavior newSchedulerModelBehavior(SchedulerModel model) {
        return new SchedulerModelBehavior(model);
    }

    protected static enum GroupOrientation {
        horizontal,
        vertical;

    }
}

