/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.interaction.droppable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.interaction.droppable.IDroppableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;

public abstract class DroppableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
IDroppableListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoDropTarget";
    private JQueryAjaxBehavior onDropAjaxBehavior;
    private JQueryAjaxBehavior onDragEnterAjaxBehavior = null;
    private JQueryAjaxBehavior onDragLeaveAjaxBehavior = null;
    private transient Component draggable = null;

    public DroppableBehavior(String selector) {
        this(selector, new Options());
    }

    public DroppableBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    public void setDraggable(Component draggable) {
        this.draggable = draggable;
    }

    protected String getOnDragEnterStatement() {
        return "";
    }

    protected String getOnDragLeaveStatement() {
        return "";
    }

    protected String getOnDropStatement() {
        StringBuilder statement = new StringBuilder();
        statement.append("var $clone = jQuery(e.target),");
        statement.append("$element = e.draggable.element;");
        statement.append("$element.removeClass('").append("kendoDraggable-hide").append("');");
        statement.append("$element.offset($clone.offset());");
        return statement.toString();
    }

    public void bind(Component component) {
        super.bind(component);
        this.onDropAjaxBehavior = this.newOnDropAjaxBehavior(this, this.getOnDropStatement());
        component.add(new Behavior[]{this.onDropAjaxBehavior});
        if (this.isDragEnterEventEnabled()) {
            this.onDragEnterAjaxBehavior = this.newOnDragEnterAjaxBehavior(this, this.getOnDragEnterStatement());
            component.add(new Behavior[]{this.onDragEnterAjaxBehavior});
        }
        if (this.isDragLeaveEventEnabled()) {
            this.onDragLeaveAjaxBehavior = this.newOnDragLeaveAjaxBehavior(this, this.getOnDragLeaveStatement());
            component.add(new Behavior[]{this.onDragLeaveAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("drop", this.onDropAjaxBehavior.getCallbackFunction());
        if (this.onDragEnterAjaxBehavior != null) {
            this.setOption("dragenter", this.onDragEnterAjaxBehavior.getCallbackFunction());
        }
        if (this.onDragLeaveAjaxBehavior != null) {
            this.setOption("dragleave", this.onDragLeaveAjaxBehavior.getCallbackFunction());
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DropEvent) {
            this.onDrop(target, this.draggable);
        } else if (event instanceof DragEnterEvent) {
            this.onDragEnter(target, this.draggable);
        } else if (event instanceof DragLeaveEvent) {
            this.onDragLeave(target, this.draggable);
        }
    }

    protected JQueryAjaxBehavior newOnDragEnterAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDragEnterAjaxBehavior(source, statement);
    }

    protected JQueryAjaxBehavior newOnDragLeaveAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDragLeaveAjaxBehavior(source, statement);
    }

    protected JQueryAjaxBehavior newOnDropAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDropAjaxBehavior(source, statement);
    }

    protected static class DropEvent
    extends JQueryEvent {
        protected DropEvent() {
        }
    }

    protected static class DragLeaveEvent
    extends JQueryEvent {
        protected DragLeaveEvent() {
        }
    }

    protected static class DragEnterEvent
    extends JQueryEvent {
        protected DragEnterEvent() {
        }
    }

    protected static class OnDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDropAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }

    protected static class OnDragLeaveAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDragLeaveAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragLeaveEvent();
        }
    }

    protected static class OnDragEnterAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDragEnterAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragEnterEvent();
        }
    }
}

