/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.interaction.droppable;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.kendo.ui.interaction.droppable.DroppableBehavior;
import com.googlecode.wicket.kendo.ui.interaction.droppable.IDroppableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;

public abstract class Droppable<T>
extends JQueryGenericContainer<T>
implements IDroppableListener {
    private static final long serialVersionUID = 1L;

    public Droppable(String id) {
        super(id);
    }

    public Droppable(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public boolean isDragEnterEventEnabled() {
        return false;
    }

    @Override
    public boolean isDragLeaveEventEnabled() {
        return false;
    }

    @Override
    public abstract void onDrop(AjaxRequestTarget var1, Component var2);

    @Override
    public void onDragEnter(AjaxRequestTarget target, Component component) {
    }

    @Override
    public void onDragLeave(AjaxRequestTarget target, Component component) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DroppableBehavior(selector){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isDragEnterEventEnabled() {
                return Droppable.this.isDragEnterEventEnabled();
            }

            @Override
            public boolean isDragLeaveEventEnabled() {
                return Droppable.this.isDragLeaveEventEnabled();
            }

            @Override
            public void onDragEnter(AjaxRequestTarget target, Component component) {
                Droppable.this.onDragEnter(target, component);
            }

            @Override
            public void onDragLeave(AjaxRequestTarget target, Component component) {
                Droppable.this.onDragLeave(target, component);
            }

            @Override
            public void onDrop(AjaxRequestTarget target, Component component) {
                Droppable.this.onDrop(target, component);
            }
        };
    }
}

