/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.interaction.draggable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.interaction.draggable.DraggableBehavior;
import com.googlecode.wicket.kendo.ui.interaction.draggable.IDraggableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class Draggable<T>
extends JQueryGenericContainer<T>
implements IDraggableListener {
    private static final long serialVersionUID = 1L;
    private Options options;

    public Draggable(String id) {
        this(id, new Options());
    }

    public Draggable(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public Draggable(String id, IModel<T> model) {
        this(id, model, new Options());
    }

    public Draggable(String id, IModel<T> model, Options options) {
        super(id, model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    @Override
    public boolean isCancelEventEnabled() {
        return false;
    }

    @Override
    public void onDragStart(AjaxRequestTarget target, int top, int left) {
    }

    @Override
    public void onDragStop(AjaxRequestTarget target, int top, int left) {
    }

    @Override
    public void onDragCancel(AjaxRequestTarget target, int top, int left) {
    }

    public Draggable<T> setAxis(Axis axis) {
        this.options.set("axis", (Object)Options.asString((Object)((Object)axis)));
        return this;
    }

    protected Draggable<T> getHint(String function) {
        this.options.set("hint", (Object)function);
        return this;
    }

    public Draggable<T> setDistance(Integer distance) {
        this.options.set("distance", (Object)distance);
        return this;
    }

    public Draggable<T> setContainer(Component component) {
        return this.setContainer(IJQueryWidget.JQueryWidget.getSelector((Component)component));
    }

    public Draggable<T> setContainer(String selector) {
        this.options.set("container", (Object)String.format("jQuery(%s)", Options.asString((String)selector)));
        return this;
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DraggableBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCancelEventEnabled() {
                return Draggable.this.isCancelEventEnabled();
            }

            @Override
            public void onDragStart(AjaxRequestTarget target, int top, int left) {
                Draggable.this.onDragStart(target, top, left);
            }

            @Override
            public void onDragStop(AjaxRequestTarget target, int top, int left) {
                Draggable.this.onDragStop(target, top, left);
            }

            @Override
            public void onDragCancel(AjaxRequestTarget target, int top, int left) {
                Draggable.this.onDragCancel(target, top, left);
            }
        };
    }

    public static enum Axis {
        X("x"),
        Y("y");

        private String axis;

        private Axis(String axis) {
            this.axis = axis;
        }

        public String toString() {
            return this.axis;
        }
    }
}

