/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.multiselect.lazy;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.ChoiceModelBehavior;
import com.googlecode.wicket.jquery.core.data.IChoiceProvider;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.utils.RendererUtils;
import com.googlecode.wicket.kendo.ui.form.multiselect.lazy.MultiSelectBehavior;
import com.googlecode.wicket.kendo.ui.renderer.ChoiceRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public abstract class MultiSelect<T>
extends FormComponent<Collection<T>>
implements IJQueryWidget,
IChoiceProvider<T> {
    private static final long serialVersionUID = 1L;
    private ChoiceModelBehavior<T> choiceModelBehavior;
    private List<T> choices = null;
    private ChoiceRenderer<? super T> renderer;
    private int width = 0;

    public MultiSelect(String id) {
        super(id);
    }

    public MultiSelect(String id, ChoiceRenderer<? super T> renderer) {
        super(id);
        this.renderer = renderer;
    }

    public MultiSelect(String id, IModel<? extends Collection<T>> model) {
        this(id, model, new ChoiceRenderer());
    }

    public MultiSelect(String id, IModel<? extends Collection<T>> model, ChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.renderer = renderer;
    }

    public int getListWidth() {
        return this.width;
    }

    public MultiSelect<T> setListWidth(int width) {
        this.width = width;
        return this;
    }

    private List<T> internalGetChoices() {
        this.choices = this.getChoices();
        return this.choices;
    }

    protected Collection<T> convertValue(String[] values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        if (this.choices != null) {
            block0: for (T object : this.choices) {
                for (String value : values) {
                    if (!value.equals(this.renderer.getText(object))) continue;
                    list.add(object);
                    continue block0;
                }
            }
        }
        return list;
    }

    public void updateModel() {
        FormComponent.updateCollectionModel((FormComponent)this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("value", (Object)this.getModelValue());
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        behavior.setOption("dataValueField", (Object)Options.asString((String)this.renderer.getValueField()));
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    protected String getModelValue() {
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : (Collection)this.getModelObject()) {
            values.add(RendererUtils.toJson(value, this.renderer));
        }
        return ((Object)values).toString();
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new MultiSelectBehavior(selector){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getChoiceCallbackUrl() {
                return MultiSelect.this.choiceModelBehavior.getCallbackUrl();
            }
        };
    }

    protected ChoiceModelBehavior<T> newChoiceModelBehavior() {
        return new ChoiceModelBehavior<T>((ITextRenderer)this.renderer){
            private static final long serialVersionUID = 1L;

            public List<T> getChoices() {
                return MultiSelect.this.internalGetChoices();
            }
        };
    }
}

