/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.utils.KendoDateTimeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class LocalTextField<T>
extends TextField<T>
implements AbstractTextComponent.ITextFormatProvider,
IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final IConverter<T> converter;
    final Options options;

    public LocalTextField(String id, IModel<T> model, String pattern, Options options, Class<T> type, IConverter<T> converter) {
        super(id, model, type);
        this.pattern = pattern;
        this.options = options;
        this.converter = converter;
    }

    public final String getTextFormat() {
        return this.pattern;
    }

    public String getModelObjectAsString() {
        Object date = this.getModelObject();
        if (date != null) {
            return this.converter.convertToString(date, this.getLocale());
        }
        return "";
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (this.getType().isAssignableFrom(type)) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    protected abstract String getMethod();

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        if (behavior.getOption("format") == null) {
            behavior.setOption("format", (Object)Options.asString((String)KendoDateTimeUtils.toPattern(this.getTextFormat())));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoUIBehavior(selector, this.getMethod(), this.options);
    }
}

