/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.button;

import com.googlecode.wicket.kendo.ui.form.button.AjaxButton;
import com.googlecode.wicket.kendo.ui.widget.window.MessageWindow;
import com.googlecode.wicket.kendo.ui.widget.window.Window;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ConfirmAjaxButton
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;

    public ConfirmAjaxButton(String id, String label, String title, String message) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)label)), (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)));
    }

    public ConfirmAjaxButton(String id, IModel<String> label, IModel<String> title, IModel<String> message) {
        super(id, message);
        final Window<?> window = this.newWindow("window", title, (IModel<String>)this.getModel());
        this.add(new Component[]{window});
        AjaxButton button = new AjaxButton("button"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getIcon() {
                return ConfirmAjaxButton.this.getIcon();
            }

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.setDefaultFormProcessing(false);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.open(target);
            }
        };
        this.add(new Component[]{button});
        button.add(new Component[]{new Label("label", label).setRenderBodyOnly(true)});
    }

    protected String getIcon() {
        return "note";
    }

    protected abstract void onError(AjaxRequestTarget var1);

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected Window<?> newWindow(String id, IModel<String> title, IModel<String> message) {
        return new MessageWindow(id, title, message, WindowButtons.OK_CANCEL, "note"){
            private static final long serialVersionUID = 1L;

            @Override
            protected Form<?> getForm() {
                return Form.findForm((Component)ConfirmAjaxButton.this);
            }

            @Override
            protected void onError(AjaxRequestTarget target, WindowButton button) {
                super.close(target);
                ConfirmAjaxButton.this.onError(target);
            }

            @Override
            public void onSubmit(AjaxRequestTarget target, WindowButton button) {
                if (button != null) {
                    if (button.match("OK")) {
                        ConfirmAjaxButton.this.onSubmit(target);
                    } else if (button.match("CANCEL")) {
                        ConfirmAjaxButton.this.onCancel(target);
                    }
                }
            }
        };
    }
}

