/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.util.string.StringValue;

public class ToolbarAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private String property;

    public static String getValuesFunction(String grid, String property) {
        return String.format("function() { var values = []; var grid = %s; grid.select().each(function(index, row) { values.push(grid.dataItem(row)['%s']); }); return values; }()", grid, property);
    }

    public ToolbarAjaxBehavior(IJQueryAjaxAware source, String property) {
        super(source);
        this.property = property;
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"button", (String)"jQuery(e.target).attr('class').match(/k-grid-(\\w+)/)[1]"), CallbackParameter.resolved((String)"values", (String)ToolbarAjaxBehavior.getValuesFunction("jQuery(e.target).closest('.k-grid').data('kendoGrid')", this.property))};
    }

    protected JQueryEvent newEvent() {
        return new ToolbarClickEvent();
    }

    protected static class ToolbarClickEvent
    extends JQueryEvent {
        private final String button = RequestCycleUtils.getQueryParameterValue((String)"button").toString();
        private final List<String> values = new ArrayList<String>();

        public ToolbarClickEvent() {
            StringValue values = RequestCycleUtils.getQueryParameterValue((String)"values");
            if (values != null) {
                for (String value : values.toString().split(",")) {
                    this.values.add(value);
                }
            }
        }

        public String getButton() {
            return this.button;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

