/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.datatable.ColumnAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.ColumnButton;
import com.googlecode.wicket.kendo.ui.datatable.IDataTableListener;
import com.googlecode.wicket.kendo.ui.datatable.ToolbarAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.column.CommandsColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.string.Strings;

public abstract class DataTableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
IDataTableListener {
    private static final long serialVersionUID = 1L;
    static final String METHOD = "kendoGrid";
    protected final List<? extends IColumn> columns;
    private JQueryAjaxBehavior onToolbarClickAjaxBehavior;

    public DataTableBehavior(String selector, List<? extends IColumn> columns) {
        this(selector, new Options(), columns);
    }

    public DataTableBehavior(String selector, Options options, List<? extends IColumn> columns) {
        super(selector, METHOD, options);
        this.columns = columns;
    }

    public void bind(Component component) {
        super.bind(component);
        for (ColumnButton button : this.getColumnButtons()) {
            component.add(new Behavior[]{this.newButtonAjaxBehavior(this, button)});
        }
        this.onToolbarClickAjaxBehavior = this.newToolbarClickAjaxBehavior(this);
        if (this.onToolbarClickAjaxBehavior != null) {
            component.add(new Behavior[]{this.onToolbarClickAjaxBehavior});
        }
    }

    protected abstract long getRowCount();

    protected abstract CharSequence getSourceCallbackUrl();

    protected Options getSchemaModel() {
        return new Options();
    }

    protected List<ColumnButton> getColumnButtons() {
        for (IColumn iColumn : this.columns) {
            if (!(iColumn instanceof CommandsColumn)) continue;
            return ((CommandsColumn)iColumn).getButtons();
        }
        return Collections.emptyList();
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.onToolbarClickAjaxBehavior != null) {
            this.on(this.selector + " .k-grid-toolbar .k-button", "click", this.onToolbarClickAjaxBehavior.getCallbackFunction());
        }
        Options source = new Options();
        Options schema = new Options();
        schema.set("data", (Object)Options.asString((String)"results"));
        schema.set("total", (Object)Options.asString((String)"__count"));
        schema.set("model", (Object)this.getSchemaModel());
        source.set("type", (Object)Options.asString((String)"json"));
        source.set("pageSize", (Object)this.getRowCount());
        source.set("serverPaging", (Object)true);
        source.set("serverSorting", (Object)true);
        source.set("serverFiltering", (Object)true);
        source.set("transport", (Object)new Options("read", (Object)Options.asString((Object)this.getSourceCallbackUrl())));
        source.set("schema", (Object)schema);
        this.setOption("dataSource", source);
        StringBuilder builder = new StringBuilder("[ ");
        for (int i = 0; i < this.columns.size(); ++i) {
            IColumn column = this.columns.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("{ ");
            builder.append(column.toString());
            if (column instanceof CommandsColumn) {
                builder.append(", ");
                builder.append("\"").append("command").append("\"").append(": ");
                builder.append("[ ");
                int n = 0;
                for (ColumnAjaxBehavior behavior : component.getBehaviors(ColumnAjaxBehavior.class)) {
                    ColumnButton button = behavior.getButton();
                    String css = button.getCSSClass();
                    if (n++ > 0) {
                        builder.append(", ");
                    }
                    builder.append("{ ");
                    builder.append("'name': '").append(button.getName()).append("', ");
                    builder.append("'text': '").append(button.toString()).append("', ");
                    if (!Strings.isEmpty((CharSequence)css)) {
                        builder.append("'className': '").append(css).append("', ");
                    }
                    builder.append("'click': ").append(behavior.getCallbackFunction());
                    builder.append(" }");
                }
                builder.append(" ]");
            }
            builder.append(" }");
        }
        this.setOption("columns", builder.append(" ]").toString());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ColumnAjaxBehavior.ClickEvent) {
            ColumnAjaxBehavior.ClickEvent e = (ColumnAjaxBehavior.ClickEvent)event;
            e.getButton().onClick(target, e.getValue());
            this.onClick(target, e.getButton(), e.getValue());
        } else if (event instanceof ToolbarAjaxBehavior.ToolbarClickEvent) {
            ToolbarAjaxBehavior.ToolbarClickEvent e = (ToolbarAjaxBehavior.ToolbarClickEvent)event;
            this.onClick(target, e.getButton(), e.getValues());
        }
    }

    protected abstract JQueryAjaxBehavior newToolbarClickAjaxBehavior(IJQueryAjaxAware var1);

    protected abstract JQueryAjaxBehavior newButtonAjaxBehavior(IJQueryAjaxAware var1, ColumnButton var2);
}

