/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.PropertyColumn;
import com.googlecode.wicket.kendo.ui.utils.PropertyUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.convert.ConversionException;

public class DataSourceBehavior<T>
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String ASC = "asc";
    private static final int COLS = 20;
    private final IDataProvider<T> provider;
    private final List<? extends IColumn> columns;

    public DataSourceBehavior(List<? extends IColumn> columns, IDataProvider<T> provider) {
        this.columns = columns;
        this.provider = provider;
    }

    protected void setSort(String property, SortOrder order) {
        ISortStateLocator locator = (ISortStateLocator)this.provider;
        locator.getSortState().setPropertySortOrder((Object)property, order);
    }

    public void onRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        int first = parameters.getParameterValue("skip").toInt(0);
        int count = parameters.getParameterValue("take").toInt(0);
        if (this.provider instanceof ISortStateLocator) {
            String property = parameters.getParameterValue("sort[0][field]").toOptionalString();
            String direction = parameters.getParameterValue("sort[0][dir]").toOptionalString();
            if (property != null) {
                this.setSort(PropertyUtils.unescape(property), direction == null ? SortOrder.NONE : (direction.equals(ASC) ? SortOrder.ASCENDING : SortOrder.DESCENDING));
            }
        }
        if (this.provider instanceof IFilterStateLocator) {
            String logicPattern = "filter[logic]";
            String fieldPattern = "filter[filters][%d][field]";
            String valuePattern = "filter[filters][%d][value]";
            String operatorPattern = "filter[filters][%d][operator]";
            Object object = ((IFilterStateLocator)this.provider).getFilterState();
            PropertyResolverConverter converter = this.newPropertyResolverConverter();
            for (int i = 0; i < 20; ++i) {
                String field = parameters.getParameterValue(String.format(fieldPattern, i)).toOptionalString();
                String value = parameters.getParameterValue(String.format(valuePattern, i)).toOptionalString();
                if (field == null) break;
                PropertyResolver.setValue((String)PropertyUtils.unescape(field), (Object)object, (Object)value, (PropertyResolverConverter)converter);
            }
        }
        requestCycle.scheduleRequestHandlerAfterCurrent(this.newRequestHandler(first, count));
    }

    protected PropertyResolverConverter newPropertyResolverConverter() {
        return new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
    }

    private IRequestHandler newRequestHandler(final int first, final int count) {
        return new IRequestHandler(){

            public void respond(IRequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                response.setContentType("application/json; charset=" + encoding);
                response.disableCaching();
                long size = DataSourceBehavior.this.provider.size();
                Iterator iterator = DataSourceBehavior.this.provider.iterator((long)first, (long)count);
                StringBuilder builder = new StringBuilder();
                builder.append("{ ");
                builder.append("\"").append("__count").append("\"").append(": ").append(size).append(", ");
                builder.append("\"").append("results").append("\"").append(": ");
                builder.append("[ ");
                if (iterator != null) {
                    int index = 0;
                    while (iterator.hasNext()) {
                        if (index > 0) {
                            builder.append(", ");
                        }
                        builder.append(DataSourceBehavior.this.newJsonRow(iterator.next()));
                        ++index;
                    }
                }
                builder.append(" ] }");
                response.write((CharSequence)builder);
            }

            public void detach(IRequestCycle requestCycle) {
                DataSourceBehavior.this.provider.detach();
            }
        };
    }

    protected String newJsonRow(T bean) {
        JSONObject object = new JSONObject();
        try {
            for (IColumn iColumn : this.columns) {
                if (!(iColumn instanceof PropertyColumn)) continue;
                PropertyColumn pc = (PropertyColumn)iColumn;
                object.put(pc.getField(), pc.getValue(bean));
            }
        }
        catch (JSONException e) {
            throw new ConversionException((Throwable)e);
        }
        return object.toString();
    }
}

