/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import java.io.Serializable;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public class ColumnButton
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static short sequence = 0;
    private final int id = ColumnButton.nextSequence();
    private final String name;
    private final IModel<String> text;
    private final String property;

    private static synchronized int nextSequence() {
        short s = sequence;
        sequence = (short)(s + 1);
        return s % Short.MAX_VALUE;
    }

    public ColumnButton(String name, String property) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)name)), property);
    }

    public ColumnButton(String name, IModel<String> text, String property) {
        this.name = name;
        this.text = text;
        this.property = property;
    }

    public String getName() {
        return this.name;
    }

    public IModel<String> getText() {
        return this.text;
    }

    public String getProperty() {
        return this.property;
    }

    protected String getCSSClass() {
        return "";
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof ColumnButton) {
            return this.match(object.toString());
        }
        return super.equals(object);
    }

    public boolean match(String text) {
        return Strings.isEqual((String)text, (String)this.toString());
    }

    public String toString() {
        return (String)this.text.getObject();
    }

    public void onClick(AjaxRequestTarget target, String value) {
    }
}

