/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.IKendoDataSource;
import org.apache.wicket.util.lang.Args;

public class KendoDataSource
extends Options
implements IKendoDataSource {
    private static final long serialVersionUID = 1L;
    protected static final String TYPE = "json";
    private final String name;
    private final Options transport;

    public KendoDataSource(String name) {
        this(name, TYPE);
    }

    public KendoDataSource(String name, String type) {
        this.name = (String)Args.notNull((Object)name, (String)"name");
        this.transport = new Options();
        this.set("type", Options.asString((String)type));
        this.set("sync", "function() { this.read(); }");
        this.set("error", "function (xhr, error) { var dw = Wicket.Ajax.DebugWindow; if (typeof dw !== 'undefined') { dw.logError(kendo.stringify(xhr)); } }");
    }

    public String getName() {
        return "window." + this.name;
    }

    @Override
    public String getToken() {
        return "kendo-" + this.name;
    }

    public void setTransportRead(String function) {
        this.transport.set("read", (Object)function);
    }

    public void setTransportCreate(String function) {
        this.transport.set("create", (Object)function);
    }

    public void setTransportUpdate(String function) {
        this.transport.set("update", (Object)function);
    }

    public void setTransportDelete(String function) {
        this.transport.set("destroy", (Object)function);
    }

    @Override
    public IKendoDataSource prepareRender() {
        this.set("transport", this.transport);
        return this;
    }

    @Override
    public String toScript() {
        return String.format("jQuery(function() { %s = new kendo.data.DataSource(%s); });", this.getName(), this.toString());
    }
}

