/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.window.IWindowListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;

public abstract class WindowBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
IWindowListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoWindow";
    private JQueryAjaxBehavior onActionBehavior = null;
    private JQueryAjaxBehavior onCloseBehavior = null;

    public WindowBehavior(String selector) {
        super(selector, METHOD);
    }

    public WindowBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.isActionEventEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onActionBehavior = this.newActionBehavior();
            behaviorArray[0] = this.onActionBehavior;
            component.add(behaviorArray);
        }
        if (this.isCloseEventEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.onCloseBehavior = this.newCloseBehavior();
            behaviorArray[0] = this.onCloseBehavior;
            component.add(behaviorArray);
        }
    }

    @Override
    protected String widget() {
        return this.widget(METHOD);
    }

    public void open(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)(this.widget() + ".open()"));
    }

    public void close(AjaxRequestTarget target) {
        target.prependJavaScript((CharSequence)(this.widget() + ".close()"));
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.onActionBehavior != null) {
            this.on(String.format("%s.wrapper.find('a.k-window-action').click(%s);", this.widget(), this.onActionBehavior.getCallbackFunction()));
        }
        if (this.onCloseBehavior != null) {
            this.setOption("close", this.onCloseBehavior.getCallbackFunction());
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ActionEvent) {
            this.onAction(target, ((ActionEvent)event).getAction());
        }
        if (event instanceof CloseEvent) {
            this.onClose(target);
        }
    }

    protected JQueryAjaxBehavior newActionBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"action", (String)"jQuery(e.target).attr('class').match(/k-i-(\\w+)/)[1]")};
            }

            protected JQueryEvent newEvent() {
                return new ActionEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newCloseBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            public String getCallbackFunction() {
                return "function(e) { if (e.userTriggered) { " + this.getCallbackScript() + " } }";
            }

            protected JQueryEvent newEvent() {
                return new CloseEvent();
            }
        };
    }

    protected static class CloseEvent
    extends JQueryEvent {
        protected CloseEvent() {
        }
    }

    protected static class ActionEvent
    extends JQueryEvent {
        private final String action = RequestCycleUtils.getQueryParameterValue((String)"action").toString();

        public String getAction() {
            return this.action;
        }
    }
}

