/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.kendo.ui.widget.window.AbstractWindow;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtonPanel;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class Window<T>
extends AbstractWindow<T> {
    private static final long serialVersionUID = 1L;
    public static final String LBL_OK = "OK";
    public static final String LBL_NO = "No";
    public static final String LBL_YES = "Yes";
    public static final String LBL_CLOSE = "Close";
    public static final String LBL_CANCEL = "Cancel";
    public static final String LBL_SUBMIT = "Submit";
    private final List<WindowButton> buttons;

    public Window(String id, String title, WindowButtons buttons) {
        this(id, title, buttons.toList());
    }

    public Window(String id, String title, List<WindowButton> buttons) {
        super(id, title);
        this.buttons = (List)Args.notNull(buttons, (String)"buttons");
    }

    public Window(String id, IModel<String> title, WindowButtons buttons) {
        this(id, title, buttons.toList());
    }

    public Window(String id, IModel<String> title, List<WindowButton> buttons) {
        super(id, title);
        this.buttons = (List)Args.notNull(buttons, (String)"buttons");
    }

    public Window(String id, String title, IModel<T> model, WindowButtons buttons) {
        this(id, title, model, buttons.toList());
    }

    public Window(String id, String title, IModel<T> model, List<WindowButton> buttons) {
        super(id, title, model);
        this.buttons = (List)Args.notNull(buttons, (String)"buttons");
    }

    public Window(String id, IModel<String> title, IModel<T> model, WindowButtons buttons) {
        this(id, title, model, buttons.toList());
    }

    public Window(String id, IModel<String> title, IModel<T> model, List<WindowButton> buttons) {
        super(id, title, model);
        this.buttons = (List)Args.notNull(buttons, (String)"buttons");
    }

    protected abstract Form<?> getForm();

    protected List<WindowButton> getButtons() {
        return this.buttons;
    }

    protected void onError(AjaxRequestTarget target, WindowButton button) {
    }

    protected void onSubmit(AjaxRequestTarget target, WindowButton button) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target, WindowButton button) {
        this.close(target);
    }

    protected WindowButtonPanel newButtonPanel(String id, List<WindowButton> buttons) {
        return new WindowButtonPanel(id, buttons){
            private static final long serialVersionUID = 1L;

            @Override
            protected Form<?> getForm() {
                return Window.this.getForm();
            }

            @Override
            protected void onError(AjaxRequestTarget target, WindowButton button) {
                Window.this.onError(target, button);
            }

            @Override
            protected void onSubmit(AjaxRequestTarget target, WindowButton button) {
                Window.this.onSubmit(target, button);
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target, WindowButton button) {
                Window.this.onAfterSubmit(target, button);
            }
        };
    }
}

