/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.kendo.ui.form.TextField;
import com.googlecode.wicket.kendo.ui.form.button.AjaxButton;
import com.googlecode.wicket.kendo.ui.panel.KendoFeedbackPanel;
import com.googlecode.wicket.kendo.ui.widget.window.AbstractWindow;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class InputWindow<T>
extends AbstractWindow<T> {
    private static final long serialVersionUID = 1L;
    private KendoFeedbackPanel feedback;
    private final IModel<String> label;
    private final Form<Void> form;

    public InputWindow(String id, String title, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), null, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<String> label) {
        this(id, title, null, label);
    }

    public InputWindow(String id, String title, IModel<T> model, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<T> model, IModel<String> label) {
        super(id, title, model, true);
        this.label = label;
        this.form = new Form("form");
    }

    protected boolean isRequired() {
        return false;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.form});
        this.feedback = new KendoFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
        this.form.add(new Component[]{new Label("label", this.label)});
        this.form.add(new Component[]{new TextField("input", this.getModel()).setRequired(this.isRequired())});
        this.form.add(new Component[]{this.newSubmitButton("submit")});
        this.form.add(new Component[]{this.newCancelButton("cancel")});
    }

    @Override
    protected void onOpen(AjaxRequestTarget target) {
        super.onOpen(target);
        target.add(new Component[]{this.form});
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected void onAfterSubmit(AjaxRequestTarget target) {
        this.close(target);
    }

    private AjaxButton newSubmitButton(String id) {
        return new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getIcon() {
                return "tick";
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> unused) {
                InputWindow.this.onSubmit(target);
            }

            @Override
            protected void onError(AjaxRequestTarget target, Form<?> unused) {
                target.add(new Component[]{InputWindow.this.feedback});
            }

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> unused) {
                InputWindow.this.onAfterSubmit(target);
            }
        };
    }

    private AjaxButton newCancelButton(String id) {
        return new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getIcon() {
                return "cancel";
            }

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.setDefaultFormProcessing(false);
            }

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> unused) {
                InputWindow.this.onAfterSubmit(target);
            }
        };
    }
}

