/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.tabs;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.tabs.AjaxTab;
import com.googlecode.wicket.kendo.ui.widget.tabs.ITabsListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;

public abstract class TabsBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
ITabsListener {
    private static final long serialVersionUID = 1L;
    static final String METHOD = "kendoTabStrip";
    private static final int DEFAULT_TAB = 0;
    int activeTab = 0;
    private JQueryAjaxBehavior selectEventBehavior = null;
    private JQueryAjaxBehavior showEventBehavior = null;
    private JQueryAjaxBehavior activateEventBehavior = null;

    public TabsBehavior(String selector) {
        super(selector, METHOD);
    }

    public TabsBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    protected abstract List<ITab> getTabs();

    protected List<ITab> getVisibleTabs() {
        ArrayList<ITab> list = new ArrayList<ITab>();
        for (ITab tab : this.getTabs()) {
            if (!tab.isVisible()) continue;
            list.add(tab);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    protected String widget() {
        return this.widget(METHOD);
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.isSelectEventEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.selectEventBehavior = this.newSelectEventBehavior();
            behaviorArray[0] = this.selectEventBehavior;
            component.add(behaviorArray);
        }
        if (this.isShowEventEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.showEventBehavior = this.newShowEventBehavior();
            behaviorArray[0] = this.showEventBehavior;
            component.add(behaviorArray);
        }
        if (this.isActivateEventEnabled()) {
            Behavior[] behaviorArray = new Behavior[1];
            this.activateEventBehavior = this.newActivateEventBehavior();
            behaviorArray[0] = this.activateEventBehavior;
            component.add(behaviorArray);
        }
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)String.format("jQuery(function() { %s.select(%d); } );", this.widget(), this.activeTab), (String)(this.getToken() + "-select")));
    }

    public void select(int index, AjaxRequestTarget target) {
        this.activeTab = index;
        target.appendJavaScript((CharSequence)String.format("%s.select(%d);", this.widget(), this.activeTab));
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.selectEventBehavior != null) {
            this.setOption("select", this.selectEventBehavior.getCallbackFunction());
        }
        if (this.showEventBehavior != null) {
            this.setOption("show", this.showEventBehavior.getCallbackFunction());
        }
        if (this.activateEventBehavior != null) {
            this.setOption("activate", this.activateEventBehavior.getCallbackFunction());
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof AbtractTabEvent) {
            int index = ((AbtractTabEvent)event).getIndex();
            List<ITab> tabs = this.getVisibleTabs();
            if (-1 < index && index < tabs.size()) {
                ITab tab = tabs.get(index);
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                if (event instanceof SelectEvent) {
                    this.onSelect(target, index, tab);
                }
                if (event instanceof ShowEvent) {
                    this.onShow(target, index, tab);
                }
                if (event instanceof ActivateEvent) {
                    this.onActivate(target, index, tab);
                }
            }
        }
    }

    protected JQueryAjaxBehavior newSelectEventBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"jQuery(e.item).index()")};
            }

            protected JQueryEvent newEvent() {
                return new SelectEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newShowEventBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"jQuery(e.item).index()")};
            }

            protected JQueryEvent newEvent() {
                return new ShowEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newActivateEventBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"jQuery(e.item).index()")};
            }

            protected JQueryEvent newEvent() {
                return new SelectEvent();
            }
        };
    }

    protected static class ActivateEvent
    extends AbtractTabEvent {
        protected ActivateEvent() {
        }
    }

    protected static class ShowEvent
    extends AbtractTabEvent {
        protected ShowEvent() {
        }
    }

    protected static class SelectEvent
    extends AbtractTabEvent {
        protected SelectEvent() {
        }
    }

    protected static abstract class AbtractTabEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }
}

