/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.tabs;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryPanel;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.tabs.ITabsListener;
import com.googlecode.wicket.kendo.ui.widget.tabs.TabsBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class TabbedPanel
extends JQueryPanel
implements ITabsListener {
    private static final long serialVersionUID = 1L;
    private TabsBehavior widgetBehavior;

    public TabbedPanel(String id) {
        this(id, new ArrayList<ITab>(), new Options());
    }

    public TabbedPanel(String id, Options options) {
        this(id, new ArrayList<ITab>(), options);
    }

    public TabbedPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public TabbedPanel(String id, List<ITab> tabs, Options options) {
        this(id, (IModel<List<ITab>>)new ListModel(tabs), options);
    }

    public TabbedPanel(String id, IModel<List<ITab>> model) {
        this(id, model, new Options());
    }

    public TabbedPanel(String id, IModel<List<ITab>> model, Options options) {
        super(id, model, options);
    }

    public List<ITab> getModelObject() {
        List list = (List)this.getDefaultModelObject();
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public TabbedPanel setActiveTab(int index) {
        this.widgetBehavior.activeTab = index;
        return this;
    }

    public void setActiveTab(int index, AjaxRequestTarget target) {
        this.widgetBehavior.select(index, target);
    }

    @Override
    public boolean isSelectEventEnabled() {
        return true;
    }

    @Override
    public boolean isShowEventEnabled() {
        return false;
    }

    @Override
    public boolean isActivateEventEnabled() {
        return false;
    }

    public boolean add(ITab tab) {
        return this.getModelObject().add(tab);
    }

    protected void onInitialize() {
        super.onInitialize();
        final RepeatingView panels = new RepeatingView("panels"){
            private static final long serialVersionUID = 1L;

            public String newChildId() {
                return String.format("tab-%s-%s", this.getMarkupId(), super.newChildId());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.removeAll();
            }
        };
        this.add(new Component[]{panels});
        this.add(new Component[]{new ListView<ITab>("tabs", this.getModelObject()){
            private static final long serialVersionUID = 1L;

            protected ListItem<ITab> newItem(int index, IModel<ITab> model) {
                ListItem item = super.newItem(index, model);
                item.setVisible(((ITab)model.getObject()).isVisible());
                return item;
            }

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                if (tab.isVisible()) {
                    item.add(new Component[]{TabbedPanel.this.newTitleLabel("title", (IModel<String>)tab.getTitle())});
                    String newId = panels.newChildId();
                    panels.add(new Component[]{tab.getPanel(newId).setMarkupId(newId).setOutputMarkupId(true)});
                }
            }
        }});
        Behavior[] behaviorArray = new Behavior[1];
        this.widgetBehavior = (TabsBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        behaviorArray[0] = this.widgetBehavior;
        this.add(behaviorArray);
    }

    @Override
    public void onSelect(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onShow(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    protected Label newTitleLabel(String id, IModel<String> title) {
        return new Label(id, title);
    }

    public TabsBehavior newWidgetBehavior(String selector) {
        return new TabsBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ITab> getTabs() {
                return TabbedPanel.this.getModelObject();
            }

            @Override
            public boolean isSelectEventEnabled() {
                return TabbedPanel.this.isSelectEventEnabled();
            }

            @Override
            public boolean isShowEventEnabled() {
                return TabbedPanel.this.isShowEventEnabled();
            }

            @Override
            public boolean isActivateEventEnabled() {
                return TabbedPanel.this.isActivateEventEnabled();
            }

            @Override
            public void onSelect(AjaxRequestTarget target, int index, ITab tab) {
                TabbedPanel.this.onSelect(target, index, tab);
            }

            @Override
            public void onShow(AjaxRequestTarget target, int index, ITab tab) {
                TabbedPanel.this.onShow(target, index, tab);
            }

            @Override
            public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
                TabbedPanel.this.onActivate(target, index, tab);
            }
        };
    }
}

