/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.accordion;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryPanel;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.accordion.AccordionBehavior;
import com.googlecode.wicket.kendo.ui.widget.accordion.IAccordionListener;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;

public class AccordionPanel
extends JQueryPanel
implements IAccordionListener {
    private static final long serialVersionUID = 1L;
    private AccordionBehavior widgetBehavior;

    public AccordionPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public AccordionPanel(String id, List<ITab> tabs, Options options) {
        this(id, (IModel<List<ITab>>)new ListModel(tabs), options);
    }

    public AccordionPanel(String id, IModel<List<ITab>> model, Options options) {
        super(id, model, options);
    }

    public List<ITab> getModelObject() {
        List list = (List)this.getDefaultModelObject();
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    private Model<Integer> getCountModel() {
        return new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AccordionPanel.this.getModelObject().size();
            }
        };
    }

    public AccordionPanel setTabIndex(int index) {
        this.widgetBehavior.tabIndex = index;
        return this;
    }

    public void setTabIndex(int index, AjaxRequestTarget target) {
        this.widgetBehavior.select(index, target);
    }

    public int getLastTabIndex() {
        int index = -1;
        for (ITab tab : this.getModelObject()) {
            if (!tab.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public boolean isSelectEventEnabled() {
        return true;
    }

    @Override
    public boolean isActivateEventEnabled() {
        return false;
    }

    @Override
    public boolean isExpandEventEnabled() {
        return false;
    }

    @Override
    public boolean isCollapseEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer root = new WebMarkupContainer("root");
        this.add(new Component[]{root});
        root.add(new Component[]{new Loop("tabs", (IModel)this.getCountModel()){
            private static final long serialVersionUID = 1L;

            protected LoopItem newItem(int index) {
                ITab tab = AccordionPanel.this.getModelObject().get(index);
                LoopItem item = super.newItem(index);
                item.setVisible(tab.isVisible());
                return item;
            }

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ITab tab = AccordionPanel.this.getModelObject().get(index);
                item.add(new Component[]{AccordionPanel.this.newTitleLabel("title", (IModel<String>)tab.getTitle())});
                item.add(new Component[]{tab.getPanel("panel")});
            }
        }});
        Behavior[] behaviorArray = new Behavior[1];
        this.widgetBehavior = (AccordionBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)root);
        behaviorArray[0] = this.widgetBehavior;
        this.add(behaviorArray);
    }

    @Override
    public void onSelect(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onExpand(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onCollapse(AjaxRequestTarget target, int index, ITab tab) {
    }

    protected Label newTitleLabel(String id, IModel<String> title) {
        return new Label(id, title);
    }

    public AccordionBehavior newWidgetBehavior(String selector) {
        return new AccordionBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isSelectEventEnabled() {
                return AccordionPanel.this.isSelectEventEnabled();
            }

            @Override
            public boolean isActivateEventEnabled() {
                return AccordionPanel.this.isActivateEventEnabled();
            }

            @Override
            public boolean isExpandEventEnabled() {
                return AccordionPanel.this.isExpandEventEnabled();
            }

            @Override
            public boolean isCollapseEventEnabled() {
                return AccordionPanel.this.isCollapseEventEnabled();
            }

            @Override
            protected List<ITab> getTabs() {
                return AccordionPanel.this.getModelObject();
            }

            @Override
            public void onSelect(AjaxRequestTarget target, int index, ITab tab) {
                AccordionPanel.this.onSelect(target, index, tab);
            }

            @Override
            public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
                AccordionPanel.this.onActivate(target, index, tab);
            }

            @Override
            public void onExpand(AjaxRequestTarget target, int index, ITab tab) {
                AccordionPanel.this.onExpand(target, index, tab);
            }

            @Override
            public void onCollapse(AjaxRequestTarget target, int index, ITab tab) {
                AccordionPanel.this.onCollapse(target, index, tab);
            }
        };
    }
}

