/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler.resource;

import com.googlecode.wicket.jquery.core.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.io.IClusterable;

public class Id<T>
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("(\\d+)");
    private final T id;

    private Id(T id) {
        this.id = id;
    }

    public T get() {
        return this.id;
    }

    public String getValue() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Id)) {
            return false;
        }
        Id other = (Id)object;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static <I> Id<?> valueOf(I id) {
        if (id instanceof String) {
            String value = String.valueOf(id);
            Matcher matcher = PATTERN.matcher(value);
            if (matcher.find() && value.equals(matcher.group())) {
                return new NumberId(value);
            }
            return new StringId(value);
        }
        if (id instanceof Number) {
            return new NumberId((Number)id);
        }
        throw new UnsupportedOperationException("argument 'id' should either be a String or a Number");
    }

    public static <I> List<Id<?>> valueOf(List<I> ids) {
        ArrayList list = new ArrayList();
        for (I id : ids) {
            list.add(Id.valueOf(id));
        }
        return list;
    }

    private static class NumberId
    extends Id<Number> {
        private static final long serialVersionUID = 1L;

        public NumberId(Number id) {
            super(id);
        }

        public NumberId(String id) {
            super(Integer.valueOf(id));
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    private static class StringId
    extends Id<String> {
        private static final long serialVersionUID = 1L;

        public StringId(String id) {
            super(id);
        }

        public String toString() {
            return Options.asString((String)((String)this.get()));
        }
    }
}

