/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import java.util.Date;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerEventFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerEventFactory.class);

    public static String toJson(SchedulerEvent event) {
        try {
            JSONObject object = new JSONObject();
            object.put("id", event.getId());
            object.put("isAllDay", event.isAllDay());
            if (event.getTitle() != null) {
                object.put("title", (Object)event.getTitle());
            }
            if (event.getDescription() != null) {
                object.put("description", (Object)event.getDescription());
            }
            if (event.getStart() != null) {
                object.put("start", (Object)DateUtils.toISO8601((Date)event.getStart()));
            }
            if (event.getEnd() != null) {
                object.put("end", (Object)DateUtils.toISO8601((Date)event.getEnd()));
            }
            if (event.getRecurrenceId() != null) {
                object.put("recurrenceId", (Object)event.getRecurrenceId());
            }
            if (event.getRecurrenceRule() != null) {
                object.put("recurrenceRule", (Object)event.getRecurrenceRule());
            }
            if (event.getRecurrenceException() != null) {
                object.put("recurrenceException", (Object)event.getRecurrenceException());
            }
            for (String field : event.getFields()) {
                object.put(field, event.getValue(field));
            }
            return object.toString();
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private SchedulerEventFactory() {
    }
}

