/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerVisitor;
import com.googlecode.wicket.kendo.ui.scheduler.resource.Id;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchedulerEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_RANGE = 1;
    public static final int NEW_ID = 0;
    private int id;
    private String title;
    private String description;
    private Date start;
    private Date end;
    private boolean allDay;
    private String recurrenceId;
    private String recurrenceRule;
    private String recurrenceException;
    private Map<String, Object> resources = new HashMap<String, Object>();

    public static boolean isNew(SchedulerEvent event) {
        return event != null && event.id == 0;
    }

    public SchedulerEvent() {
        this(0, "", new Date());
    }

    public SchedulerEvent(int id, String title, long start) {
        this(id, title, new Date(start));
    }

    public SchedulerEvent(int id, String title, Date start) {
        this(id, title, start, DateUtils.addHours((Date)start, (int)1));
    }

    public SchedulerEvent(int id, String title, long start, long end) {
        this(id, title, new Date(start), new Date(end));
    }

    public SchedulerEvent(int id, String title, Date start, Date end) {
        this.id = id;
        this.title = title;
        this.description = null;
        this.start = start;
        this.end = end;
        this.allDay = false;
        this.recurrenceId = null;
        this.recurrenceRule = null;
        this.recurrenceException = null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date date) {
        this.start = date;
    }

    public void setStart(long date) {
        this.start = new Date(date);
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date date) {
        this.end = date;
    }

    public void setEnd(long date) {
        this.end = new Date(date);
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(String id) {
        this.recurrenceId = id;
    }

    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    public void setRecurrenceRule(String rule) {
        this.recurrenceRule = rule;
    }

    public String getRecurrenceException() {
        return this.recurrenceException;
    }

    public void setRecurrenceException(String exception) {
        this.recurrenceException = exception;
    }

    public Set<String> getFields() {
        return this.resources.keySet();
    }

    public final Object getValue(String field) {
        Object object = this.resources.get(field);
        if (object instanceof Id) {
            return ((Id)object).get();
        }
        if (object instanceof List) {
            ArrayList list = new ArrayList();
            for (Id id : (List)object) {
                list.add(id.get());
            }
            return list;
        }
        return null;
    }

    public final void setResource(String field, String id) {
        this.resources.put(field, Id.valueOf(id));
    }

    public final void setResource(String field, Integer id) {
        this.resources.put(field, Id.valueOf(id));
    }

    public final void setResource(String field, List<?> ids) {
        this.resources.put(field, Id.valueOf(ids));
    }

    public final void accept(ISchedulerVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.title;
    }
}

