/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.local.LocalTextField;
import java.util.Locale;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class TimePicker
extends LocalTextField<LocalTime> {
    private static final long serialVersionUID = 1L;
    protected static final String METHOD = "kendoTimePicker";
    protected static final String DEFAULT_PATTERN = "h:mm a";

    private static IConverter<LocalTime> newConverter(final String pattern) {
        return new IConverter<LocalTime>(){
            private static final long serialVersionUID = 1L;

            public LocalTime convertToObject(String value, Locale locale) throws ConversionException {
                try {
                    return Strings.isEmpty((CharSequence)value) ? null : LocalTime.parse((CharSequence)value, (DateTimeFormatter)DateTimeFormatter.ofPattern((String)pattern));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalTime date, Locale locale) {
                return date == null ? null : date.format(DateTimeFormatter.ofPattern((String)pattern));
            }
        };
    }

    public TimePicker(String id) {
        this(id, DEFAULT_PATTERN, new Options());
    }

    public TimePicker(String id, Options options) {
        this(id, DEFAULT_PATTERN, options);
    }

    public TimePicker(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public TimePicker(String id, String pattern, Options options) {
        this(id, null, pattern, options);
    }

    public TimePicker(String id, Locale locale) {
        this(id, locale, new Options());
    }

    public TimePicker(String id, Locale locale, Options options) {
        this(id, null, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)DEFAULT_PATTERN), options.set("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)locale))));
    }

    public TimePicker(String id, IModel<LocalTime> model) {
        this(id, model, DEFAULT_PATTERN, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, Options options) {
        this(id, model, DEFAULT_PATTERN, options);
    }

    public TimePicker(String id, IModel<LocalTime> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, String pattern, Options options) {
        super(id, model, pattern, options, LocalTime.class, TimePicker.newConverter(pattern));
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale) {
        this(id, model, locale, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale, Options options) {
        this(id, model, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)DEFAULT_PATTERN), options.set("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)locale))));
    }

    @Override
    protected String getMethod() {
        return METHOD;
    }
}

