/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.kendo.ui.form.datetime.local.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.TimePicker;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class DateTimePicker
extends FormComponentPanel<LocalDateTime>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_NOT_INITIALIZED = "Internal timePicker is not initialized (#onInitialize() has not yet been called).";
    DatePicker datePicker;
    TimePicker timePicker;
    private final String datePattern;
    private final String timePattern;
    private IConverter<LocalDateTime> converter;

    private static IConverter<LocalDateTime> newConverter(final String format) {
        return new IConverter<LocalDateTime>(){
            private static final long serialVersionUID = 1L;

            public LocalDateTime convertToObject(String value, Locale locale) throws ConversionException {
                try {
                    return Strings.isEmpty((CharSequence)value) ? null : LocalDateTime.parse((CharSequence)value, (DateTimeFormatter)DateTimeFormatter.ofPattern((String)format));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalDateTime date, Locale locale) {
                return date == null ? null : date.format(DateTimeFormatter.ofPattern((String)format));
            }
        };
    }

    public DateTimePicker(String id) {
        this(id, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        super(id);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    public DateTimePicker(String id, IModel<LocalDateTime> date) {
        this(id, date, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, IModel<LocalDateTime> date, String datePattern, String timePattern) {
        super(id, date);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    protected void convertInput() {
        LocalDate date = (LocalDate)this.datePicker.getConvertedInput();
        LocalTime time = (LocalTime)this.timePicker.getConvertedInput();
        this.setConvertedInput(date == null ? null : LocalDateTime.of((LocalDate)date, (LocalTime)(time == null ? LocalTime.MIDNIGHT : time)));
    }

    protected String formatInput(String dateInput, String timeInput) {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", dateInput, timeInput);
        }
        return dateInput;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (LocalDateTime.class.isAssignableFrom(type)) {
            if (this.converter == null) {
                this.converter = DateTimePicker.newConverter(this.getTextFormat());
            }
            return this.converter;
        }
        return super.getConverter(type);
    }

    public final String getDatePattern() {
        return this.datePicker.getTextFormat();
    }

    public final String getTimePattern() {
        return this.timePicker.getTextFormat();
    }

    public final boolean isTimePickerEnabled() {
        if (this.timePicker != null) {
            return this.timePicker.isEnabled();
        }
        throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
    }

    public final void setTimePickerEnabled(boolean enabled) {
        if (this.timePicker == null) {
            throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
        }
        this.timePicker.setEnabled(enabled);
    }

    public final void setTimePickerEnabled(AjaxRequestTarget target, boolean enabled) {
        this.setTimePickerEnabled(enabled);
        target.add(new Component[]{this.timePicker});
    }

    public final String getTextFormat() {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
        }
        return this.getDatePattern();
    }

    public String getModelObjectAsString() {
        LocalDateTime date = (LocalDateTime)this.getModelObject();
        if (date != null) {
            return date.format(DateTimeFormatter.ofPattern((String)this.getTextFormat()));
        }
        return "";
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", (IModel<LocalDate>)new PropertyModel((Object)this.getModel(), "date"), this.datePattern);
        this.timePicker = this.newTimePicker("timepicker", (IModel<LocalTime>)new PropertyModel((Object)this.getModel(), "time"), this.timePattern);
        this.add(new Component[]{this.datePicker});
        this.add(new Component[]{this.timePicker});
    }

    protected DatePicker newDatePicker(String id, IModel<LocalDate> model, String datePattern) {
        return new DatePicker(id, model, datePattern);
    }

    protected TimePicker newTimePicker(String id, IModel<LocalTime> model, String timePattern) {
        return new TimePicker(id, model, timePattern);
    }
}

