/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime;

import com.googlecode.wicket.kendo.ui.form.datetime.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.TimePicker;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimePicker
extends FormComponentPanel<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DateTimePicker.class);
    private static final String ERROR_NOT_INITIALIZED = "Internal timePicker is not initialized (#onInitialize() has not yet been called).";
    DatePicker datePicker;
    TimePicker timePicker;
    private final String datePattern;
    private final String timePattern;
    private IConverter<Date> converter;

    private static IConverter<Date> newConverter(final String format) {
        return new DateConverter(){
            private static final long serialVersionUID = 1L;

            public DateFormat getDateFormat(Locale locale) {
                Locale l = locale;
                if (l == null) {
                    l = Locale.getDefault();
                }
                return new SimpleDateFormat(format, l);
            }
        };
    }

    public DateTimePicker(String id) {
        this(id, "MM/dd/yyyy", "h:mm aa");
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        super(id);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    public DateTimePicker(String id, IModel<Date> date) {
        this(id, date, "MM/dd/yyyy", "h:mm aa");
    }

    public DateTimePicker(String id, IModel<Date> date, String datePattern, String timePattern) {
        super(id, date);
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    protected void convertInput() {
        IConverter<Date> converter = this.getConverter(Date.class);
        String dateInput = this.datePicker.getInput();
        String timeInput = this.timePicker.getInput();
        try {
            Date date = (Date)converter.convertToObject(this.formatInput(dateInput, timeInput), this.getLocale());
            this.setConvertedInput(date);
        }
        catch (ConversionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            ValidationError error = new ValidationError();
            error.addKey("DateTimePicker.ConversionError");
            error.setVariable("date", (Object)dateInput);
            error.setVariable("time", (Object)timeInput);
            this.error((IValidationError)error);
        }
    }

    protected String formatInput(String dateInput, String timeInput) {
        if (!this.isTimePickerEnabled()) {
            return dateInput;
        }
        return String.format("%s %s", dateInput, timeInput);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (Date.class.isAssignableFrom(type)) {
            if (this.converter == null) {
                this.converter = DateTimePicker.newConverter(this.getTextFormat());
            }
            return this.converter;
        }
        return super.getConverter(type);
    }

    public final String getDatePattern() {
        return this.datePicker.getTextFormat();
    }

    public final String getTimePattern() {
        return this.timePicker.getTextFormat();
    }

    public final boolean isTimePickerEnabled() {
        if (this.timePicker != null) {
            return this.timePicker.isEnabled();
        }
        throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
    }

    public final void setTimePickerEnabled(boolean enabled) {
        if (this.timePicker == null) {
            throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
        }
        this.timePicker.setEnabled(enabled);
    }

    public final void setTimePickerEnabled(AjaxRequestTarget target, boolean enabled) {
        this.setTimePickerEnabled(enabled);
        target.add(new Component[]{this.timePicker});
    }

    public final String getTextFormat() {
        if (!this.isTimePickerEnabled()) {
            return this.getDatePattern();
        }
        return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat()).format(date);
        }
        return "";
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", (IModel<Date>)this.getModel(), this.datePattern);
        this.timePicker = this.newTimePicker("timepicker", (IModel<Date>)this.getModel(), this.timePattern);
        this.add(new Component[]{this.datePicker});
        this.add(new Component[]{this.timePicker});
    }

    protected DatePicker newDatePicker(String id, IModel<Date> model, String datePattern) {
        return new DatePicker(id, model, datePattern);
    }

    protected TimePicker newTimePicker(String id, IModel<Date> model, String timePattern) {
        return new TimePicker(id, model, timePattern);
    }
}

