/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.combobox;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.RendererUtils;
import com.googlecode.wicket.kendo.ui.KendoTemplateBehavior;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.renderer.ChoiceRenderer;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class ComboBox<T>
extends TextField<String>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoComboBox";
    private final IModel<List<T>> choices;
    private final ChoiceRenderer<? super T> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    private int width = 0;

    public ComboBox(String id, List<T> choices) {
        this(id, (IModel<List<T>>)new ListModel(choices), (ChoiceRenderer<? super T>)new ChoiceRenderer());
    }

    public ComboBox(String id, List<T> choices, ChoiceRenderer<? super T> renderer) {
        this(id, (IModel<List<? super T>>)new ListModel(choices), renderer);
    }

    public ComboBox(String id, IModel<List<T>> choices) {
        this(id, choices, new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<List<T>> choices, ChoiceRenderer<? super T> renderer) {
        super(id);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public ComboBox(String id, IModel<String> model, List<T> choices) {
        this(id, model, (IModel<List<T>>)new ListModel(choices), (ChoiceRenderer<? super T>)new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<String> model, List<T> choices, ChoiceRenderer<? super T> renderer) {
        this(id, model, (IModel<List<? super T>>)new ListModel(choices), renderer);
    }

    public ComboBox(String id, IModel<String> model, IModel<List<T>> choices) {
        this(id, model, choices, new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<String> model, IModel<List<T>> choices, ChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public int getListWidth() {
        return this.width;
    }

    public ComboBox<?> setListWidth(int width) {
        this.width = width;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            Behavior[] behaviorArray = new Behavior[1];
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            behaviorArray[0] = this.templateBehavior;
            this.add(behaviorArray);
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("dataSource", (Object)this.newDataSource());
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        behavior.setOption("dataValueField", (Object)Options.asString((String)this.renderer.getValueField()));
        if (this.template != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.templateBehavior.getToken()));
        }
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoUIBehavior(selector, METHOD);
    }

    protected String newDataSource() {
        StringBuilder builder = new StringBuilder("[");
        List list = (List)this.choices.getObject();
        if (list != null) {
            for (int index = 0; index < list.size(); ++index) {
                Object object = list.get(index);
                if (index > 0) {
                    builder.append(", ");
                }
                builder.append("{ ");
                builder.append(RendererUtils.getJsonBody(object, this.renderer));
                if (this.template != null) {
                    for (String property : this.template.getTextProperties()) {
                        builder.append(", ");
                        builder.append(RendererUtils.getJsonBody(object, this.renderer, (String)property));
                    }
                }
                builder.append(" }");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }
}

