/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.button;

import com.googlecode.wicket.jquery.core.panel.FormSubmittingPanel;
import com.googlecode.wicket.kendo.ui.form.button.AjaxButton;
import com.googlecode.wicket.kendo.ui.widget.window.MessageWindow;
import com.googlecode.wicket.kendo.ui.widget.window.Window;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ConfirmButton
extends FormSubmittingPanel<String> {
    private static final long serialVersionUID = 1L;

    public ConfirmButton(String id, String label, String title, String message) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)label)), (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)));
    }

    public ConfirmButton(String id, IModel<String> label, IModel<String> title, IModel<String> message) {
        super(id, message);
        final Window<?> window = this.newWindow("window", title, (IModel<String>)this.getModel());
        this.add(new Component[]{window});
        AjaxButton button = new AjaxButton("button"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.setDefaultFormProcessing(false);
            }

            @Override
            protected String getIcon() {
                return ConfirmButton.this.getIcon();
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.open(target);
            }
        };
        this.add(new Component[]{button});
        button.add(new Component[]{new Label("label", label).setRenderBodyOnly(true)});
    }

    protected String getIcon() {
        return "note";
    }

    protected Window<?> newWindow(String id, IModel<String> title, IModel<String> message) {
        return new MessageWindow(id, title, message, WindowButtons.OK_CANCEL, "note"){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit(AjaxRequestTarget target, WindowButton button) {
                if (button != null && button.match("OK")) {
                    ConfirmButton.this.submit(target);
                }
            }
        };
    }
}

