/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.button;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.form.button.ButtonBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public class AjaxIndicatingButtonBehavior
extends ButtonBehavior {
    private static final long serialVersionUID = 1L;
    protected static final String CSS_INDICATOR = "indicator";

    public AjaxIndicatingButtonBehavior(String selector) {
        super(selector);
    }

    public AjaxIndicatingButtonBehavior(String selector, Options options) {
        super(selector, options);
    }

    public AjaxIndicatingButtonBehavior(String selector, String icon) {
        super(selector, icon);
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        String css = String.format(".k-i-%s { background-image: url(%s); background-position: 0 0; }", CSS_INDICATOR, RequestCycle.get().urlFor((IRequestHandler)handler));
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)css, (String)"kendo-ui-icon-indicator"));
    }

    protected String $() {
        StringBuilder builder = new StringBuilder(super.$());
        builder.append("jQuery('").append(this.selector).append("')").append(".click(function() { ");
        builder.append(this.$(this.newOnClickOptions()));
        builder.append(" }); ");
        builder.append("jQuery(document).ajaxStop(function() { ");
        builder.append("jQuery('").append(this.selector).append(" .").append("k-icon").append("').remove(); ");
        builder.append("jQuery('").append(this.selector).append("').removeAttr('disabled'); ");
        builder.append(this.$(this.options));
        builder.append(" }); ");
        return builder.toString();
    }

    protected Options newOnClickOptions() {
        return new Options("icon", (Object)Options.asString((String)CSS_INDICATOR));
    }
}

