/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.autocomplete;

import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.kendo.ui.form.autocomplete.AbstractAutoCompleteTextField;
import java.util.Locale;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class AutoCompleteTextField<T>
extends AbstractAutoCompleteTextField<T, T> {
    private static final long serialVersionUID = 1L;
    private final IConverter<T> converter = this.newConverter();

    public AutoCompleteTextField(String id) {
        super(id);
    }

    public AutoCompleteTextField(String id, ITextRenderer<? super T> renderer) {
        super(id, renderer);
    }

    public AutoCompleteTextField(String id, IModel<T> model) {
        super(id, model);
    }

    public AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer) {
        super(id, model, renderer);
    }

    protected final String getModelValue() {
        return this.renderer.getText(this.getModelObject());
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (!String.class.isAssignableFrom(this.getType()) && type != null && type.isAssignableFrom(this.getType())) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    @Override
    protected final void onSelected(AjaxRequestTarget target, T choice) {
        this.setModelObject(choice);
        this.onSelected(target);
    }

    protected void onSelected(AjaxRequestTarget target) {
    }

    private final IConverter<T> newConverter() {
        return new IConverter<T>(){
            private static final long serialVersionUID = 1L;

            public T convertToObject(String value, Locale locale) {
                if (value != null && value.equals(AutoCompleteTextField.this.getModelValue())) {
                    return AutoCompleteTextField.this.getModelObject();
                }
                return null;
            }

            public String convertToString(T value, Locale locale) {
                return AutoCompleteTextField.this.renderer.getText(value);
            }
        };
    }
}

