/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.autocomplete;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.form.autocomplete.IAutoCompleteListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;

public abstract class AutoCompleteBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware,
IAutoCompleteListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "kendoAutoComplete";
    private JQueryAjaxBehavior onSelectBehavior = null;

    public AutoCompleteBehavior(String selector) {
        this(selector, new Options());
    }

    public AutoCompleteBehavior(String selector, Options options) {
        super(selector, METHOD, options);
    }

    public void bind(Component component) {
        super.bind(component);
        Behavior[] behaviorArray = new Behavior[1];
        this.onSelectBehavior = this.newOnSelectBehavior();
        behaviorArray[0] = this.onSelectBehavior;
        component.add(behaviorArray);
    }

    protected abstract CharSequence getChoiceCallbackUrl();

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("autoBind", true);
        this.setOption("serverFiltering", true);
        this.setOption("dataSource", this.newDataSource());
        this.setOption("select", this.onSelectBehavior.getCallbackFunction());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            this.onSelect(target, ((SelectEvent)event).getIndex());
        }
    }

    protected String newDataSource() {
        return String.format("{ serverFiltering: true, transport: { read: { url: '%s', dataType: 'json' } }, error: %s }", this.getChoiceCallbackUrl(), "function (xhr, error) { var dw = Wicket.Ajax.DebugWindow; if (typeof dw !== 'undefined') { dw.logError(kendo.stringify(xhr)); } }");
    }

    protected JQueryAjaxBehavior newOnSelectBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"e.item.index()"), CallbackParameter.resolved((String)"value", (String)"e.item.text")};
            }

            protected JQueryEvent newEvent() {
                return new SelectEvent();
            }
        };
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);
        private final String value = RequestCycleUtils.getQueryParameterValue((String)"value").toString();

        public int getIndex() {
            return this.index;
        }

        public String getValue() {
            return this.value;
        }
    }
}

