/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.export;

import com.googlecode.wicket.jquery.core.utils.ConverterUtils;
import com.googlecode.wicket.kendo.ui.datatable.DataTable;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import com.googlecode.wicket.kendo.ui.datatable.column.IExportableColumn;
import com.googlecode.wicket.kendo.ui.datatable.export.IDataExporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.AbstractResourceStreamWriter;
import org.apache.wicket.util.resource.IResourceStream;

public class CSVDataExporter
implements IDataExporter {
    private static final long serialVersionUID = 1L;
    private static final char QUOTE = '\"';
    private static final String CRLF = "\r\n";
    private static final String MIME = "text/csv";
    private static final char delimiter = ',';
    private static final String characterSet = "utf-8";
    private final String contentType;
    private boolean exportHeadersEnabled = true;

    public static void export(DataTable<?> table, String filename) {
        CSVDataExporter.export(RequestCycle.get(), table, filename);
    }

    public static void export(RequestCycle cycle, DataTable<?> table, String filename) {
        ArrayList<IExportableColumn> columns = new ArrayList<IExportableColumn>();
        for (IColumn column : table.getColumns()) {
            if (!(column instanceof IExportableColumn)) continue;
            columns.add((IExportableColumn)column);
        }
        CSVDataExporter.export(cycle, table.getDataProvider(), columns, filename);
    }

    public static void export(RequestCycle cycle, IDataProvider<?> provider, List<IExportableColumn> columns, String filename) {
        DataExporterResourceStreamWriter writer = new DataExporterResourceStreamWriter(new CSVDataExporter(), provider, columns);
        cycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)writer, filename));
    }

    public CSVDataExporter() {
        this(MIME);
    }

    public CSVDataExporter(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return String.format("%s; charset=%s; header=%s", this.contentType, characterSet, this.exportHeadersEnabled ? "present" : "absent");
    }

    @Override
    public boolean isExportHeadersEnabled() {
        return this.exportHeadersEnabled;
    }

    protected String quoteValue(String value) {
        return '\"' + value.replace("\"", "\"\"") + '\"';
    }

    private void exportHeaders(List<IExportableColumn> columns, PrintWriter writer) {
        boolean first = true;
        for (IExportableColumn column : columns) {
            if (first) {
                first = false;
            } else {
                writer.print(',');
            }
            writer.print(this.quoteValue(column.getTitle()));
        }
        writer.print(CRLF);
    }

    private <T> void exportRow(IDataProvider<T> provider, List<IExportableColumn> columns, T row, PrintWriter writer) {
        boolean first = true;
        for (IExportableColumn column : columns) {
            Object object;
            if (first) {
                first = false;
            } else {
                writer.print(',');
            }
            if ((object = column.newDataModel(provider.model(row)).getObject()) == null) continue;
            String value = ConverterUtils.toString((Object)object);
            writer.print(this.quoteValue(value));
        }
        writer.print(CRLF);
    }

    @Override
    public <T> void exportData(IDataProvider<T> provider, List<IExportableColumn> columns, OutputStream output) throws IOException {
        this.exportData(provider, columns, output, 0L, provider.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void exportData(IDataProvider<T> provider, List<IExportableColumn> columns, OutputStream output, long first, long count) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, Charset.forName(characterSet)));
        try {
            if (this.isExportHeadersEnabled()) {
                this.exportHeaders(columns, writer);
            }
            Iterator iterator = provider.iterator(first, count);
            while (iterator.hasNext()) {
                this.exportRow(provider, columns, iterator.next(), writer);
            }
        }
        finally {
            writer.close();
        }
    }

    public static class DataExporterResourceStreamWriter
    extends AbstractResourceStreamWriter {
        private static final long serialVersionUID = 1L;
        private final IDataExporter exporter;
        private final IDataProvider<?> provider;
        private final List<IExportableColumn> columns;

        public DataExporterResourceStreamWriter(IDataExporter exporter, IDataProvider<?> provider, List<IExportableColumn> columns) {
            this.exporter = exporter;
            this.provider = provider;
            this.columns = columns;
        }

        public String getContentType() {
            return this.exporter.getContentType();
        }

        public void write(OutputStream output) throws IOException {
            this.exporter.exportData(this.provider, this.columns, output);
        }
    }
}

